/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvEdDSAPublicKey;
import org.bouncycastle.util.Arrays;

class ProvEdDSAPrivateKey
implements Destroyable,
EdDSAPrivateKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricEdDSAPrivateKey baseKey;
    private transient AsymmetricEdDSAPublicKey basePublicKey;

    ProvEdDSAPrivateKey(AsymmetricEdDSAPrivateKey asymmetricEdDSAPrivateKey, AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey) {
        this.baseKey = asymmetricEdDSAPrivateKey;
        this.basePublicKey = asymmetricEdDSAPublicKey;
    }

    ProvEdDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.baseKey = new AsymmetricEdDSAPrivateKey(privateKeyInfo);
        this.basePublicKey = new AsymmetricEdDSAPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
    }

    @Override
    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    AsymmetricEdDSAPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public EdDSAPublicKey getPublicKey() {
        return new ProvEdDSAPublicKey(this.basePublicKey);
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("EdDSA");
        }
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), this.basePublicKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvEdDSAPrivateKey)) {
            return false;
        }
        ProvEdDSAPrivateKey provEdDSAPrivateKey = (ProvEdDSAPrivateKey)object;
        return Arrays.areEqual(provEdDSAPrivateKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricEdDSAPrivateKey(byArray);
        this.basePublicKey = new AsymmetricEdDSAPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

