/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.lookup;

import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.painless.lookup.PainlessClass;
import org.opensearch.painless.lookup.PainlessClassBinding;
import org.opensearch.painless.lookup.PainlessConstructor;
import org.opensearch.painless.lookup.PainlessField;
import org.opensearch.painless.lookup.PainlessInstanceBinding;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.lookup.PainlessMethod;

public final class PainlessLookup {
    private final Map<String, Class<?>> javaClassNamesToClasses;
    private final Map<String, Class<?>> canonicalClassNamesToClasses;
    private final Map<Class<?>, PainlessClass> classesToPainlessClasses;
    private final Map<String, PainlessMethod> painlessMethodKeysToImportedPainlessMethods;
    private final Map<String, PainlessClassBinding> painlessMethodKeysToPainlessClassBindings;
    private final Map<String, PainlessInstanceBinding> painlessMethodKeysToPainlessInstanceBindings;

    PainlessLookup(Map<String, Class<?>> javaClassNamesToClasses, Map<String, Class<?>> canonicalClassNamesToClasses, Map<Class<?>, PainlessClass> classesToPainlessClasses, Map<String, PainlessMethod> painlessMethodKeysToImportedPainlessMethods, Map<String, PainlessClassBinding> painlessMethodKeysToPainlessClassBindings, Map<String, PainlessInstanceBinding> painlessMethodKeysToPainlessInstanceBindings) {
        Objects.requireNonNull(javaClassNamesToClasses);
        Objects.requireNonNull(canonicalClassNamesToClasses);
        Objects.requireNonNull(classesToPainlessClasses);
        Objects.requireNonNull(painlessMethodKeysToImportedPainlessMethods);
        Objects.requireNonNull(painlessMethodKeysToPainlessClassBindings);
        Objects.requireNonNull(painlessMethodKeysToPainlessInstanceBindings);
        this.javaClassNamesToClasses = javaClassNamesToClasses;
        this.canonicalClassNamesToClasses = CollectionUtils.copyMap(canonicalClassNamesToClasses);
        this.classesToPainlessClasses = CollectionUtils.copyMap(classesToPainlessClasses);
        this.painlessMethodKeysToImportedPainlessMethods = CollectionUtils.copyMap(painlessMethodKeysToImportedPainlessMethods);
        this.painlessMethodKeysToPainlessClassBindings = CollectionUtils.copyMap(painlessMethodKeysToPainlessClassBindings);
        this.painlessMethodKeysToPainlessInstanceBindings = CollectionUtils.copyMap(painlessMethodKeysToPainlessInstanceBindings);
    }

    public Class<?> javaClassNameToClass(String javaClassName) {
        return this.javaClassNamesToClasses.get(javaClassName);
    }

    public boolean isValidCanonicalClassName(String canonicalClassName) {
        Objects.requireNonNull(canonicalClassName);
        return "def".equals(canonicalClassName) || this.canonicalClassNamesToClasses.containsKey(canonicalClassName);
    }

    public Class<?> canonicalTypeNameToType(String canonicalTypeName) {
        Objects.requireNonNull(canonicalTypeName);
        return PainlessLookupUtility.canonicalTypeNameToType(canonicalTypeName, this.canonicalClassNamesToClasses);
    }

    public Set<Class<?>> getClasses() {
        return this.classesToPainlessClasses.keySet();
    }

    public Set<String> getImportedPainlessMethodsKeys() {
        return this.painlessMethodKeysToImportedPainlessMethods.keySet();
    }

    public Set<String> getPainlessClassBindingsKeys() {
        return this.painlessMethodKeysToPainlessClassBindings.keySet();
    }

    public Set<String> getPainlessInstanceBindingsKeys() {
        return this.painlessMethodKeysToPainlessInstanceBindings.keySet();
    }

    public PainlessClass lookupPainlessClass(Class<?> targetClass) {
        return this.classesToPainlessClasses.get(targetClass);
    }

    public PainlessConstructor lookupPainlessConstructor(String targetCanonicalClassName, int constructorArity) {
        Objects.requireNonNull(targetCanonicalClassName);
        Class<?> targetClass = this.canonicalTypeNameToType(targetCanonicalClassName);
        if (targetClass == null) {
            return null;
        }
        return this.lookupPainlessConstructor(targetClass, constructorArity);
    }

    public PainlessConstructor lookupPainlessConstructor(Class<?> targetClass, int constructorArity) {
        Objects.requireNonNull(targetClass);
        PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(targetClass);
        String painlessConstructorKey = PainlessLookupUtility.buildPainlessConstructorKey(constructorArity);
        if (targetPainlessClass == null) {
            return null;
        }
        PainlessConstructor painlessConstructor = targetPainlessClass.constructors.get(painlessConstructorKey);
        if (painlessConstructor == null) {
            return null;
        }
        return painlessConstructor;
    }

    public PainlessMethod lookupPainlessMethod(String targetCanonicalClassName, boolean isStatic, String methodName, int methodArity) {
        Objects.requireNonNull(targetCanonicalClassName);
        Class<?> targetClass = this.canonicalTypeNameToType(targetCanonicalClassName);
        if (targetClass == null) {
            return null;
        }
        return this.lookupPainlessMethod(targetClass, isStatic, methodName, methodArity);
    }

    public PainlessMethod lookupPainlessMethod(Class<?> targetClass, boolean isStatic, String methodName, int methodArity) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        if (targetClass.isPrimitive()) {
            targetClass = PainlessLookupUtility.typeToBoxedType(targetClass);
        }
        PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(targetClass);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, methodArity);
        if (targetPainlessClass == null) {
            return null;
        }
        return isStatic ? targetPainlessClass.staticMethods.get(painlessMethodKey) : targetPainlessClass.methods.get(painlessMethodKey);
    }

    public PainlessField lookupPainlessField(String targetCanonicalClassName, boolean isStatic, String fieldName) {
        Objects.requireNonNull(targetCanonicalClassName);
        Class<?> targetClass = this.canonicalTypeNameToType(targetCanonicalClassName);
        if (targetClass == null) {
            return null;
        }
        return this.lookupPainlessField(targetClass, isStatic, fieldName);
    }

    public PainlessField lookupPainlessField(Class<?> targetClass, boolean isStatic, String fieldName) {
        PainlessField painlessField;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(fieldName);
        PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(targetClass);
        String painlessFieldKey = PainlessLookupUtility.buildPainlessFieldKey(fieldName);
        if (targetPainlessClass == null) {
            return null;
        }
        PainlessField painlessField2 = painlessField = isStatic ? targetPainlessClass.staticFields.get(painlessFieldKey) : targetPainlessClass.fields.get(painlessFieldKey);
        if (painlessField == null) {
            return null;
        }
        return painlessField;
    }

    public PainlessMethod lookupImportedPainlessMethod(String methodName, int arity) {
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, arity);
        return this.painlessMethodKeysToImportedPainlessMethods.get(painlessMethodKey);
    }

    public PainlessClassBinding lookupPainlessClassBinding(String methodName, int arity) {
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, arity);
        return this.painlessMethodKeysToPainlessClassBindings.get(painlessMethodKey);
    }

    public PainlessInstanceBinding lookupPainlessInstanceBinding(String methodName, int arity) {
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, arity);
        return this.painlessMethodKeysToPainlessInstanceBindings.get(painlessMethodKey);
    }

    public PainlessMethod lookupFunctionalInterfacePainlessMethod(Class<?> targetClass) {
        PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(targetClass);
        if (targetPainlessClass == null) {
            return null;
        }
        return targetPainlessClass.functionalInterfaceMethod;
    }

    public PainlessMethod lookupRuntimePainlessMethod(Class<?> originalTargetClass, String methodName, int methodArity) {
        Objects.requireNonNull(originalTargetClass);
        Objects.requireNonNull(methodName);
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, methodArity);
        Function<PainlessClass, PainlessMethod> objectLookup = targetPainlessClass -> targetPainlessClass.runtimeMethods.get(painlessMethodKey);
        return this.lookupRuntimePainlessObject(originalTargetClass, objectLookup);
    }

    public MethodHandle lookupRuntimeGetterMethodHandle(Class<?> originalTargetClass, String getterName) {
        Objects.requireNonNull(originalTargetClass);
        Objects.requireNonNull(getterName);
        Function<PainlessClass, MethodHandle> objectLookup = targetPainlessClass -> targetPainlessClass.getterMethodHandles.get(getterName);
        return this.lookupRuntimePainlessObject(originalTargetClass, objectLookup);
    }

    public MethodHandle lookupRuntimeSetterMethodHandle(Class<?> originalTargetClass, String setterName) {
        Objects.requireNonNull(originalTargetClass);
        Objects.requireNonNull(setterName);
        Function<PainlessClass, MethodHandle> objectLookup = targetPainlessClass -> targetPainlessClass.setterMethodHandles.get(setterName);
        return this.lookupRuntimePainlessObject(originalTargetClass, objectLookup);
    }

    private <T> T lookupRuntimePainlessObject(Class<?> originalTargetClass, Function<PainlessClass, T> objectLookup) {
        Class<?> currentTargetClass;
        for (currentTargetClass = originalTargetClass; currentTargetClass != null; currentTargetClass = currentTargetClass.getSuperclass()) {
            T painlessObject;
            PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(currentTargetClass);
            if (targetPainlessClass == null || (painlessObject = objectLookup.apply(targetPainlessClass)) == null) continue;
            return painlessObject;
        }
        for (currentTargetClass = originalTargetClass; currentTargetClass != null; currentTargetClass = currentTargetClass.getSuperclass()) {
            for (Class<?> targetInterface : currentTargetClass.getInterfaces()) {
                T painlessObject;
                PainlessClass targetPainlessClass = this.classesToPainlessClasses.get(targetInterface);
                if (targetPainlessClass == null || (painlessObject = objectLookup.apply(targetPainlessClass)) == null) continue;
                return painlessObject;
            }
        }
        return null;
    }
}

