/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.health.ClusterHealthAction;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.alerting.MonitorMetadataService;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.service.DeleteMonitorService;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportIndexMonitorAction;
import org.opensearch.alerting.transport.TransportIndexMonitorActionKt;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.alerting.util.AnomalyDetectionUtilsKt;
import org.opensearch.alerting.util.DocLevelMonitorQueries;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.commons.alerting.action.IndexMonitorRequest;
import org.opensearch.commons.alerting.action.IndexMonitorResponse;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.MonitorMetadata;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.alerting.model.action.Throttle;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001DBO\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J.\u00108\u001a\u0002092\u0006\u0010\u0007\u001a\u00020\b2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030;2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?J.\u0010@\u001a\u0002092\u0006\u0010\u0007\u001a\u00020\b2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030;2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?J&\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020C2\u0006\u0010<\u001a\u00020\u00022\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030;H\u0014R\"\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u001a \u001b*\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00190\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R$\u0010\"\u001a\n \u001b*\u0004\u0018\u00010#0#X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010(\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0016\u0010)\u001a\n \u001b*\u0004\u0018\u00010*0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\n \u001b*\u0004\u0018\u00010*0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010,\u001a\n \u001b*\u0004\u0018\u00010-0-X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010.R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0016\u00101\u001a\n \u001b*\u0004\u0018\u00010*0*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006E"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/commons/alerting/action/IndexMonitorResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "docLevelMonitorQueries", "Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/core/ScheduledJobIndices;Lorg/opensearch/alerting/util/DocLevelMonitorQueries;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "allowList", "", "", "kotlin.jvm.PlatformType", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getDocLevelMonitorQueries", "()Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "filterByEnabled", "", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "maxActionThrottle", "maxMonitors", "", "Ljava/lang/Integer;", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "requestTimeout", "getScheduledJobIndices", "()Lorg/opensearch/alerting/core/ScheduledJobIndices;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "checkAnomalyDetectorAndExecute", "", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "request", "Lorg/opensearch/commons/alerting/action/IndexMonitorRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "checkIndicesAndExecute", "doExecute", "task", "Lorg/opensearch/tasks/Task;", "IndexMonitorHandler", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportIndexMonitorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction\n+ 2 TransportHelpers.kt\norg/opensearch/commons/utils/TransportHelpersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 AlertingUtils.kt\norg/opensearch/alerting/util/AlertingUtilsKt\n*L\n1#1,758:1\n48#2,5:759\n766#3:764\n857#3,2:765\n1855#3,2:767\n1549#3:769\n1620#3,3:770\n37#4,2:773\n173#5,8:775\n*S KotlinDebug\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction\n*L\n126#1:759,5\n190#1:764\n190#1:765,2\n195#1:767,2\n201#1:769\n201#1:770,3\n209#1:773,2\n254#1:775,8\n*E\n"})
public final class TransportIndexMonitorAction
extends HandledTransportAction<ActionRequest, IndexMonitorResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final DocLevelMonitorQueries docLevelMonitorQueries;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile Integer maxMonitors;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue indexTimeout;
    private volatile TimeValue maxActionThrottle;
    private volatile List<String> allowList;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportIndexMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull DocLevelMonitorQueries docLevelMonitorQueries, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry, @NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorQueries, (String)"docLevelMonitorQueries");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        super("cluster:admin/opendistro/alerting/monitor/write", transportService, actionFilters, IndexMonitorRequest::new);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.docLevelMonitorQueries = docLevelMonitorQueries;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.maxMonitors = (Integer)AlertingSettings.Companion.getALERTING_MAX_MONITORS().get(this.settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(this.settings);
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(this.settings);
        this.maxActionThrottle = (TimeValue)AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE().get(this.settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERTING_MAX_MONITORS(), arg_0 -> TransportIndexMonitorAction._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> TransportIndexMonitorAction._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), arg_0 -> TransportIndexMonitorAction._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), arg_0 -> TransportIndexMonitorAction._init_$lambda$3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), arg_0 -> TransportIndexMonitorAction._init_$lambda$4(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final DocLevelMonitorQueries getDocLevelMonitorQueries() {
        return this.docLevelMonitorQueries;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * Exception decompiling
     */
    protected void doExecute(@NotNull Task task, @NotNull ActionRequest request, @NotNull ActionListener<IndexMonitorResponse> actionListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void checkIndicesAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        indices = new ArrayList<E>();
        $this$filter$iv = request.getMonitor().getInputs();
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var12_17 = $this$filterTo$iv$iv.iterator();
        while (var12_17.hasNext()) {
            element$iv$iv = var12_17.next();
            it = (Input)element$iv$iv;
            $i$a$-filter-TransportIndexMonitorAction$checkIndicesAndExecute$searchInputs$1 = false;
            v0 = Intrinsics.areEqual((Object)it.name(), (Object)"search") || Intrinsics.areEqual((Object)it.name(), (Object)"doc_level_input") || Intrinsics.areEqual((Object)it.name(), (Object)"remote_doc_level_monitor_input");
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        searchInputs = (List)destination$iv$iv;
        $this$forEach$iv = searchInputs;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Input)element$iv /* !! */ ;
            $i$a$-forEach-TransportIndexMonitorAction$checkIndicesAndExecute$1 = false;
            if (Intrinsics.areEqual((Object)it.name(), (Object)"search")) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.SearchInput");
                v1 = ((SearchInput)it).getIndices();
            } else if (Intrinsics.areEqual((Object)it.name(), (Object)"doc_level_input")) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.DocLevelMonitorInput");
                v1 = ((DocLevelMonitorInput)it).getIndices();
            } else {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput");
                v1 = ((RemoteDocLevelMonitorInput)it).getDocLevelMonitorInput().getIndices();
            }
            inputIndices = v1;
            indices.addAll(inputIndices);
        }
        $this$map$iv = indices;
        $i$f$map = false;
        element$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-TransportIndexMonitorAction$checkIndicesAndExecute$searchInputs$1 = (String)item$iv$iv;
            var19_29 = destination$iv$iv;
            $i$a$-map-TransportIndexMonitorAction$checkIndicesAndExecute$updatedIndices$1 = false;
            v2 = this.clusterService.state();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"state(...)");
            if (IndexUtils.Companion.isAlias((String)index, v2)) ** GOTO lbl-1000
            v3 = this.clusterService.state();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"state(...)");
            if (IndexUtils.Companion.isDataStream((String)index, v3)) lbl-1000:
            // 2 sources

            {
                v4 = (IndexAbstraction)this.clusterService.state().getMetadata().getIndicesLookup().get(index);
                metadata /* !! */  = v4 != null ? v4.getWriteIndex() : null;
                v5 = metadata /* !! */ ;
                v6 = var18_28 = v5 != null && (v5 = v5.getIndex()) != null ? v5.getName() : null;
                if (v6 == null) {
                    v7 = index;
                } else {
                    Intrinsics.checkNotNull((Object)v6);
                    v7 = var18_28;
                }
            } else {
                v7 = index;
            }
            var19_29.add(v7);
        }
        updatedIndices = (List)destination$iv$iv;
        $this$toTypedArray$iv = updatedIndices;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        var9_11 = thisCollection$iv.toArray(new String[0]);
        searchRequest = new SearchRequest().indices(Arrays.copyOf(var9_11, var9_11.length)).source(SearchSourceBuilder.searchSource().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(client, this, actionListener, request, user, (List<String>)indices){
            final /* synthetic */ Client $client;
            final /* synthetic */ TransportIndexMonitorAction this$0;
            final /* synthetic */ ActionListener<IndexMonitorResponse> $actionListener;
            final /* synthetic */ IndexMonitorRequest $request;
            final /* synthetic */ User $user;
            final /* synthetic */ List<String> $indices;
            {
                this.$client = $client;
                this.this$0 = $receiver;
                this.$actionListener = $actionListener;
                this.$request = $request;
                this.$user = $user;
                this.$indices = $indices;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void onResponse(@NotNull SearchResponse searchResponse2) {
                void $this$use$iv;
                Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
                ThreadContext.StoredContext storedContext = this.$client.threadPool().getThreadContext().stashContext();
                TransportIndexMonitorAction transportIndexMonitorAction = this.this$0;
                Client client = this.$client;
                ActionListener<IndexMonitorResponse> actionListener = this.$actionListener;
                IndexMonitorRequest indexMonitorRequest = this.$request;
                User user = this.$user;
                boolean $i$f$use = false;
                Throwable exception$iv = null;
                try {
                    void it = $this$use$iv;
                    boolean bl = false;
                    transportIndexMonitorAction.new IndexMonitorHandler(client, actionListener, indexMonitorRequest, user).resolveUserAndStart();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable e$iv) {
                    exception$iv = e$iv;
                    throw e$iv;
                }
                finally {
                    AlertingUtilsKt.closeFinally((ThreadContext.StoredContext)$this$use$iv, exception$iv);
                }
            }

            public void onFailure(@NotNull Exception t) {
                Exception exception;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                boolean bl = t instanceof OpenSearchSecurityException;
                if (bl) {
                    exception = (Exception)new OpenSearchStatusException("User doesn't have read permissions for one or more configured index " + this.$indices, RestStatus.FORBIDDEN, new Object[0]);
                } else if (!bl) {
                    exception = t;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(exception));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkAnomalyDetectorAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ThreadContext.StoredContext $this$use$iv = client.threadPool().getThreadContext().stashContext();
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            ThreadContext.StoredContext it = $this$use$iv;
            boolean bl = false;
            new IndexMonitorHandler(client, actionListener, request, user).resolveUserAndStartForAD();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            exception$iv = e$iv;
            throw e$iv;
        }
        finally {
            AlertingUtilsKt.closeFinally($this$use$iv, exception$iv);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.isAdmin(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportIndexMonitorAction this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.maxMonitors = it;
    }

    private static final void _init_$lambda$1(TransportIndexMonitorAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestTimeout = it;
    }

    private static final void _init_$lambda$2(TransportIndexMonitorAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.indexTimeout = it;
    }

    private static final void _init_$lambda$3(TransportIndexMonitorAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.maxActionThrottle = it;
    }

    private static final void _init_$lambda$4(TransportIndexMonitorAction this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.allowList = it;
    }

    private static final boolean doExecute$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ TimeValue access$getIndexTimeout$p(TransportIndexMonitorAction $this) {
        return $this.indexTimeout;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u0010\u0015J.\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u0011H\u0002J\u0006\u0010*\u001a\u00020\u0011J\u0006\u0010+\u001a\u00020\u0011J\u0006\u0010,\u001a\u00020\u0011J\u000e\u0010-\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u001eJ \u0010.\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler;", "", "client", "Lorg/opensearch/transport/client/Client;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/commons/alerting/action/IndexMonitorResponse;", "request", "Lorg/opensearch/commons/alerting/action/IndexMonitorRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/alerting/transport/TransportIndexMonitorAction;Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/commons/alerting/action/IndexMonitorRequest;Lorg/opensearch/commons/authuser/User;)V", "checkShardsFailure", "", "response", "Lorg/opensearch/action/index/IndexResponse;", "cleanupMonitorAfterPartialFailure", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "indexMonitorResponse", "(Lorg/opensearch/commons/alerting/model/Monitor;Lorg/opensearch/action/index/IndexResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexDocLevelMonitorQueries", "monitorId", "monitorMetadata", "Lorg/opensearch/commons/alerting/model/MonitorMetadata;", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "(Lorg/opensearch/commons/alerting/model/Monitor;Ljava/lang/String;Lorg/opensearch/commons/alerting/model/MonitorMetadata;Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexMonitor", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onCreateMappingsResponse", "isAcknowledged", "", "onGetResponse", "currentMonitor", "(Lorg/opensearch/commons/alerting/model/Monitor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onSearchResponse", "Lorg/opensearch/action/search/SearchResponse;", "onUpdateMappingsResponse", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "prepareMonitorIndexing", "resolveUserAndStart", "resolveUserAndStartForAD", "start", "updateMonitor", "validateActionThrottle", "maxValue", "Lorg/opensearch/common/unit/TimeValue;", "minValue", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nTransportIndexMonitorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,758:1\n1855#2:759\n1855#2,2:760\n1856#2:762\n13309#3,2:763\n*S KotlinDebug\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler\n*L\n411#1:759\n412#1:760,2\n411#1:762\n748#1:763,2\n*E\n"})
    public final class IndexMonitorHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexMonitorResponse> actionListener;
        @NotNull
        private final IndexMonitorRequest request;
        @Nullable
        private final User user;

        public IndexMonitorHandler(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @Nullable IndexMonitorRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public final void resolveUserAndStart() {
            if (this.user == null) {
                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User("", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                this.start();
            } else {
                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                this.start();
            }
        }

        public final void resolveUserAndStartForAD() {
            if (this.user == null) {
                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User("", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                this.start();
            } else {
                try {
                    this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0);
                    if (AlertingUtilsKt.getRoleFilterEnabled(TransportIndexMonitorAction.this.getClusterService(), TransportIndexMonitorAction.this.getSettings(), "plugins.anomaly_detection.filter_by_backend_roles")) {
                        Intrinsics.checkNotNull((Object)searchSourceBuilder);
                        AnomalyDetectionUtilsKt.addUserBackendRolesFilter(this.user, searchSourceBuilder);
                    }
                    String[] stringArray = new String[]{".opendistro-anomaly-detectors"};
                    SearchRequest searchRequest = new SearchRequest().indices(stringArray).source(searchSourceBuilder);
                    this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                        final /* synthetic */ IndexMonitorHandler this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onResponse(@Nullable SearchResponse response2) {
                            Long totalHits;
                            SearchResponse searchResponse2 = response2;
                            Long l = searchResponse2 != null && (searchResponse2 = searchResponse2.getHits()) != null && (searchResponse2 = searchResponse2.getTotalHits()) != null ? Long.valueOf(searchResponse2.value()) : (totalHits = null);
                            if (totalHits != null && totalHits > 0L) {
                                this.this$0.start();
                            } else {
                                IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("User has no available detectors", RestStatus.NOT_FOUND, new Object[0])));
                            }
                        }

                        public void onFailure(@NotNull Exception t) {
                            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                            IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                        }
                    });
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)ex));
                }
            }
        }

        public final void start() {
            if (!TransportIndexMonitorAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexMonitorAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull CreateIndexResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onCreateMappingsResponse(this.this$0, response2.isAcknowledged());
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (ExceptionsHelper.unwrapCause((Throwable)t) instanceof ResourceAlreadyExistsException) {
                            BuildersKt.launch$default((CoroutineScope)TransportIndexMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ IndexMonitorHandler this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            var3_3 = new String[]{".opendistro-alerting-config"};
                                            request = new ClusterHealthRequest().indices(var3_3).waitForYellowStatus();
                                            this.label = 1;
                                            v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)IndexMonitorHandler.access$getClient$p(this.this$0)), (Function2)((Function2)new Function2<Client, ActionListener<ClusterHealthResponse>, Unit>(request){
                                                final /* synthetic */ ClusterHealthRequest $request;
                                                {
                                                    this.$request = $request;
                                                    super(2);
                                                }

                                                public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<ClusterHealthResponse> it) {
                                                    Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                                    $this$suspendUntil.execute((ActionType)ClusterHealthAction.INSTANCE, (ActionRequest)this.$request, it);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (v0 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl15
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl15:
                                            // 2 sources

                                            if ((response = (ClusterHealthResponse)v0).isTimedOut()) {
                                                IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)new OpenSearchException("Cannot determine that the .opendistro-alerting-config index is healthy", new Object[0]));
                                            }
                                            IndexMonitorHandler.access$onCreateMappingsResponse(this.this$0, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        } else {
                            IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                        }
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexMonitorAction.this.getClusterService().state();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"state(...)");
                IndicesAdminClient indicesAdminClient = this.client.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)indicesAdminClient, (String)"indices(...)");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", string, clusterState, indicesAdminClient, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                }));
            } else {
                this.prepareMonitorIndexing();
            }
        }

        private final void prepareMonitorIndexing() {
            try {
                Monitor monitor = this.request.getMonitor();
                TimeValue timeValue = TransportIndexMonitorAction.this.maxActionThrottle;
                Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"access$getMaxActionThrottle$p(...)");
                TimeValue timeValue2 = TimeValue.timeValueMinutes((long)1L);
                Intrinsics.checkNotNullExpressionValue((Object)timeValue2, (String)"timeValueMinutes(...)");
                this.validateActionThrottle(monitor, timeValue, timeValue2);
            }
            catch (RuntimeException e) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)e));
                return;
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                BuildersKt.launch$default((CoroutineScope)TransportIndexMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = IndexMonitorHandler.access$updateMonitor(this.this$0, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else {
                BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor.type", (String)"monitor"));
                SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query).timeout(TransportIndexMonitorAction.this.requestTimeout);
                String[] stringArray = new String[]{".opendistro-alerting-config"};
                SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSource);
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull SearchResponse searchResponse2) {
                        Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
                        IndexMonitorHandler.access$onSearchResponse(this.this$0, searchResponse2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                });
            }
        }

        private final void validateActionThrottle(Monitor monitor, TimeValue maxValue, TimeValue minValue) {
            Iterable $this$forEach$iv = monitor.getTriggers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = trigger.getActions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Action action = (Action)element$iv2;
                    boolean bl2 = false;
                    if (action.getThrottle() == null) continue;
                    Throttle throttle = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle);
                    long l = throttle.getValue();
                    Throttle throttle2 = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle2);
                    if (!(new TimeValue(Duration.of(l, throttle2.getUnit()).toMillis()).compareTo(maxValue) <= 0)) {
                        boolean $i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32 = false;
                        String $i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32 = "Can only set throttle period less than or equal to " + maxValue;
                        throw new IllegalArgumentException($i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32.toString());
                    }
                    Throttle throttle3 = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle3);
                    long l2 = throttle3.getValue();
                    Throttle throttle4 = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle4);
                    if (new TimeValue(Duration.of(l2, throttle4.getUnit()).toMillis()).compareTo(minValue) >= 0) continue;
                    boolean bl3 = false;
                    String string = "Can only set throttle period greater than or equal to " + minValue;
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void onSearchResponse(SearchResponse response2) {
            Long totalHits;
            TotalHits totalHits2 = response2.getHits().getTotalHits();
            Long l = totalHits = totalHits2 != null ? Long.valueOf(totalHits2.value()) : null;
            if (totalHits != null) {
                Integer n = TransportIndexMonitorAction.this.maxMonitors;
                if (totalHits >= (n != null ? Long.valueOf(n.intValue()) : null)) {
                    TransportIndexMonitorActionKt.access$getLog$p().info("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].");
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalArgumentException("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].")));
                    return;
                }
            }
            BuildersKt.launch$default((CoroutineScope)TransportIndexMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ IndexMonitorHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = IndexMonitorHandler.access$indexMonitor(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final void onCreateMappingsResponse(boolean isAcknowledged) {
            if (isAcknowledged) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareMonitorIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().info("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Updated  .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareMonitorIndexing();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().info("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Updated .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        /*
         * Exception decompiling
         */
        private final Object indexMonitor(Continuation<? super Unit> var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[SWITCH], 15[CASE]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Unable to fully structure code
         */
        private final Object cleanupMonitorAfterPartialFailure(Monitor var1_1, IndexResponse var2_2, Continuation<? super Unit> var3_3) {
            if (!(var3_3 instanceof cleanupMonitorAfterPartialFailure.1)) ** GOTO lbl-1000
            var6_4 = var3_3;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$cleanupMonitorAfterPartialFailure(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = indexMonitorResponse;
                    $continuation.label = 1;
                    v0 = DeleteMonitorService.INSTANCE.deleteMonitor(var1_1, WriteRequest.RefreshPolicy.IMMEDIATE, (Continuation<? super DeleteMonitorResponse>)$continuation);
                    ** if (v0 != var7_6) goto lbl19
lbl18:
                    // 1 sources

                    return var7_6;
lbl19:
                    // 1 sources

                    ** GOTO lbl26
                }
                case 1: {
                    indexMonitorResponse = (IndexResponse)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        TransportIndexMonitorActionKt.access$getLog$p().debug("Cleaned up monitor related resources after monitor creation request partial failure. Monitor id : " + indexMonitorResponse.getId());
                    }
                    catch (Exception e) {
                        TransportIndexMonitorActionKt.access$getLog$p().error("Failed to clean up monitor after monitor creation request partial failure", (Throwable)e);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object indexDocLevelMonitorQueries(Monitor var1_1, String var2_2, MonitorMetadata var3_3, WriteRequest.RefreshPolicy var4_4, Continuation<? super Unit> var5_5) {
            if (!(var5_5 instanceof indexDocLevelMonitorQueries.1)) ** GOTO lbl-1000
            var9_6 = var5_5;
            if ((var9_6.label & -2147483648) != 0) {
                var9_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_5){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$indexDocLevelMonitorQueries(this.this$0, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    queryIndex = monitor.getDataSources().getQueryIndex();
                    if (TransportIndexMonitorAction.this.getDocLevelMonitorQueries().docLevelQueryIndexExists(monitor.getDataSources())) ** GOTO lbl35
                    $continuation.L$0 = this;
                    $continuation.L$1 = monitor;
                    $continuation.L$2 = monitorId;
                    $continuation.L$3 = monitorMetadata;
                    $continuation.L$4 = refreshPolicy;
                    $continuation.L$5 = queryIndex;
                    $continuation.label = 1;
                    v0 = TransportIndexMonitorAction.this.getDocLevelMonitorQueries().initDocLevelQueryIndex(monitor.getDataSources(), (Continuation<? super Boolean>)$continuation);
                    if (v0 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl34
                }
                case 1: {
                    queryIndex = (String)$continuation.L$5;
                    refreshPolicy = (WriteRequest.RefreshPolicy)$continuation.L$4;
                    monitorMetadata = (MonitorMetadata)$continuation.L$3;
                    monitorId = (String)$continuation.L$2;
                    monitor = (Monitor)$continuation.L$1;
                    this = (IndexMonitorHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    TransportIndexMonitorActionKt.access$getLog$p().info("Central Percolation index " + queryIndex + " created");
lbl35:
                    // 2 sources

                    v1 = TransportIndexMonitorAction.this.getDocLevelMonitorQueries();
                    var7_10 = TransportIndexMonitorAction.access$getIndexTimeout$p(TransportIndexMonitorAction.this);
                    Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"access$getIndexTimeout$p(...)");
                    $continuation.L$0 = queryIndex;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.L$5 = null;
                    $continuation.label = 2;
                    v2 = v1.indexDocLevelQueries(var1_1, var2_2, var3_3, refreshPolicy, var7_10, (Continuation<? super Unit>)$continuation);
                    if (v2 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl53
                }
                case 2: {
                    queryIndex = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl53:
                    // 2 sources

                    TransportIndexMonitorActionKt.access$getLog$p().debug("Queries inserted into Percolate index " + queryIndex);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object updateMonitor(Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof updateMonitor.1)) ** GOTO lbl-1000
            var9_2 = var1_1;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$updateMonitor(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    getRequest = new GetRequest(".opendistro-alerting-config", this.request.getMonitorId());
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(this, getRequest){
                        final /* synthetic */ IndexMonitorHandler this$0;
                        final /* synthetic */ GetRequest $getRequest;
                        {
                            this.this$0 = $receiver;
                            this.$getRequest = $getRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            IndexMonitorHandler.access$getClient$p(this.this$0).get(this.$getRequest, it);
                        }
                    }), (Continuation)$continuation);
                    ** if (v0 != var10_4) goto lbl20
lbl19:
                    // 1 sources

                    return var10_4;
lbl20:
                    // 1 sources

                    ** GOTO lbl27
                }
                case 1: {
                    this = (IndexMonitorHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    if (!(getResponse = (GetResponse)v0).isExists()) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Monitor with " + this.request.getMonitorId() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return Unit.INSTANCE;
                    }
                    xcp = XContentHelper.createParser((NamedXContentRegistry)TransportIndexMonitorAction.this.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)getResponse.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                    Intrinsics.checkNotNull((Object)xcp);
                    var7_9 = getResponse.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)var7_9, (String)"getId(...)");
                    var6_10 = ScheduledJob.Companion.parse(xcp, var7_9, getResponse.getVersion());
                    Intrinsics.checkNotNull((Object)var6_10, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Monitor");
                    monitor = (Monitor)var6_10;
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.onGetResponse(monitor, (Continuation<? super Unit>)$continuation);
                    ** if (v1 != var10_4) goto lbl42
lbl41:
                    // 1 sources

                    return var10_4;
lbl42:
                    // 1 sources

                    ** GOTO lbl52
                }
                case 2: {
                    this = (IndexMonitorHandler)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
lbl52:
                    // 3 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object onGetResponse(Monitor var1_1, Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof onGetResponse.1)) ** GOTO lbl-1000
            var13_3 = var2_2;
            if ((var13_3.label & -2147483648) != 0) {
                var13_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$onGetResponse(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!TransportIndexMonitorAction.this.checkUserPermissionsWithResource(this.user, currentMonitor.getUser(), this.actionListener, "monitor", this.request.getMonitorId())) {
                        return Unit.INSTANCE;
                    }
                    if (this.request.getMonitor().getEnabled() && currentMonitor.getEnabled()) {
                        this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, (Instant)currentMonitor.getEnabledTime(), null, null, (int)0, null, null, null, null, null, null, null, (int)131007, null));
                    }
                    if (this.user != null) {
                        if (this.request.getRbacRoles() != null) {
                            if (TransportIndexMonitorAction.this.isAdmin(this.user)) {
                                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), this.request.getRbacRoles(), this.user.getRoles(), this.user.getCustomAttNames()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                            } else {
                                v0 = this.user.getBackendRoles();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getBackendRoles(...)");
                                v1 = v0;
                                v2 = this.request.getRbacRoles();
                                if (v2 == null) {
                                    v2 = CollectionsKt.emptyList();
                                }
                                rolesToRemove = CollectionsKt.minus((Iterable)v1, (Iterable)v2);
                                v3 = currentMonitor.getUser();
                                v4 = v3 != null ? v3.getBackendRoles() : null;
                                if (v4 == null) {
                                    v4 = CollectionsKt.emptyList();
                                }
                                v5 = CollectionsKt.minus((Iterable)v4, (Iterable)rolesToRemove);
                                v6 = this.request.getRbacRoles();
                                if (v6 == null) {
                                    v6 = CollectionsKt.emptyList();
                                }
                                updatedRbac = CollectionsKt.plus((Collection)v5, (Iterable)v6);
                                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), updatedRbac, this.user.getRoles(), this.user.getCustomAttNames()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                            }
                        } else {
                            v7 = this.request.getMonitor();
                            v8 = this.user.getName();
                            v9 = currentMonitor.getUser();
                            Intrinsics.checkNotNull((Object)v9);
                            this.request.setMonitor(Monitor.copy$default((Monitor)v7, null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(v8, v9.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttNames()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                        }
                        v10 = this.request.getMonitor().getUser();
                        TransportIndexMonitorActionKt.access$getLog$p().debug("Update monitor backend roles to: " + (v10 != null ? v10.getBackendRoles() : null));
                    }
                    this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, null, (int)IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, null, null, null, null, null, (int)130559, null));
                    v11 = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
                    v12 = this.request.getMonitor();
                    v13 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"jsonBuilder(...)");
                    indexRequest = (IndexRequest)v11.source(v12.toXContentWithUser(v13, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(this.request.getMonitorId()).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexMonitorAction.access$getIndexTimeout$p(TransportIndexMonitorAction.this));
                    v14 = TransportIndexMonitorActionKt.access$getLog$p();
                    v15 = currentMonitor.getId();
                    v16 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"jsonBuilder(...)");
                    v17 = currentMonitor.toXContentWithUser(v16, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))));
                    v18 = this.request.getMonitor();
                    v19 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"jsonBuilder(...)");
                    v14.info("Updating monitor, " + v15 + ", from: " + v17 + " \n to: " + v18.toXContentWithUser(v19, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true")))));
                    $continuation.L$0 = this;
                    $continuation.L$1 = currentMonitor;
                    $continuation.label = 1;
                    v20 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(this, indexRequest){
                        final /* synthetic */ IndexMonitorHandler this$0;
                        final /* synthetic */ IndexRequest $indexRequest;
                        {
                            this.this$0 = $receiver;
                            this.$indexRequest = $indexRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            IndexMonitorHandler.access$getClient$p(this.this$0).index(this.$indexRequest, it);
                        }
                    }), (Continuation)$continuation);
                    ** if (v20 != var14_5) goto lbl69
lbl68:
                    // 1 sources

                    return var14_5;
lbl69:
                    // 1 sources

                    ** GOTO lbl77
                }
                case 1: {
                    currentMonitor = (Monitor)$continuation.L$1;
                    this = (IndexMonitorHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v20 = $result;
lbl77:
                    // 2 sources

                    if ((failureReasons = this.checkShardsFailure(indexResponse = (IndexResponse)v20)) != null) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), indexResponse.status(), new Object[0])));
                        return Unit.INSTANCE;
                    }
                    isDocLevelMonitorRestarted = false;
                    if (this.request.getMonitor().getEnabled() && !currentMonitor.getEnabled() && StringsKt.endsWith$default((String)this.request.getMonitor().getMonitorType(), (String)Monitor.MonitorType.DOC_LEVEL_MONITOR.getValue(), (boolean)false, (int)2, null)) {
                        isDocLevelMonitorRestarted = true;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = currentMonitor;
                    $continuation.L$2 = indexResponse;
                    $continuation.label = 2;
                    v21 = MonitorMetadataService.getOrCreateMetadata$default(MonitorMetadataService.INSTANCE, this.request.getMonitor(), false, false, null, isDocLevelMonitorRestarted != false, (Continuation)$continuation, 14, null);
                    ** if (v21 != var14_5) goto lbl91
lbl90:
                    // 1 sources

                    return var14_5;
lbl91:
                    // 1 sources

                    ** GOTO lbl100
                }
                case 2: {
                    indexResponse = (IndexResponse)$continuation.L$2;
                    currentMonitor = (Monitor)$continuation.L$1;
                    this = (IndexMonitorHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v21 = $result;
lbl100:
                    // 2 sources

                    var8_11 = (Pair)v21;
                    metadata = (MonitorMetadata)var8_11.component1();
                    created = (Boolean)var8_11.component2();
                    if (created || !IndexUtilsKt.isMonitorOfStandardType((Monitor)currentMonitor)) ** GOTO lbl178
                    var11_14 = currentMonitor.getMonitorType();
                    v22 = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"ROOT");
                    v23 = var11_14.toUpperCase(v22);
                    Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"toUpperCase(...)");
                    if (Monitor.MonitorType.valueOf((String)v23) != Monitor.MonitorType.DOC_LEVEL_MONITOR) ** GOTO lbl178
                    $continuation.L$0 = this;
                    $continuation.L$1 = currentMonitor;
                    $continuation.L$2 = indexResponse;
                    $continuation.label = 3;
                    v24 = MonitorMetadataService.INSTANCE.recreateRunContext(metadata, currentMonitor, (Continuation<? super MonitorMetadata>)$continuation);
                    ** if (v24 != var14_5) goto lbl117
lbl116:
                    // 1 sources

                    return var14_5;
lbl117:
                    // 1 sources

                    ** GOTO lbl126
                }
                case 3: {
                    indexResponse = (IndexResponse)$continuation.L$2;
                    currentMonitor = (Monitor)$continuation.L$1;
                    this = (IndexMonitorHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v24 = $result;
lbl126:
                    // 2 sources

                    updatedMetadata = (MonitorMetadata)v24;
                    if (!TransportIndexMonitorAction.this.getDocLevelMonitorQueries().docLevelQueryIndexExists(currentMonitor.getDataSources())) ** GOTO lbl146
                    $continuation.L$0 = this;
                    $continuation.L$1 = currentMonitor;
                    $continuation.L$2 = indexResponse;
                    $continuation.L$3 = updatedMetadata;
                    $continuation.label = 4;
                    v25 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<BulkByScrollResponse>, Unit>(this, currentMonitor){
                        final /* synthetic */ IndexMonitorHandler this$0;
                        final /* synthetic */ Monitor $currentMonitor;
                        {
                            this.this$0 = $receiver;
                            this.$currentMonitor = $currentMonitor;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkByScrollResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            String[] stringArray = new String[]{this.$currentMonitor.getDataSources().getQueryIndex()};
                            ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((OpenSearchClient)IndexMonitorHandler.access$getClient$p(this.this$0), (ActionType)DeleteByQueryAction.INSTANCE).source(stringArray)).filter((QueryBuilder)QueryBuilders.matchQuery((String)"monitor_id", (Object)this.$currentMonitor.getId()))).execute(it);
                        }
                    }), (Continuation)$continuation);
                    ** if (v25 != var14_5) goto lbl136
lbl135:
                    // 1 sources

                    return var14_5;
lbl136:
                    // 1 sources

                    ** GOTO lbl146
                }
                case 4: {
                    updatedMetadata = (MonitorMetadata)$continuation.L$3;
                    indexResponse = (IndexResponse)$continuation.L$2;
                    currentMonitor = (Monitor)$continuation.L$1;
                    this = (IndexMonitorHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v25 = $result;
lbl146:
                    // 3 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = indexResponse;
                    $continuation.L$2 = updatedMetadata;
                    $continuation.L$3 = null;
                    $continuation.label = 5;
                    v26 = this.indexDocLevelMonitorQueries(this.request.getMonitor(), currentMonitor.getId(), updatedMetadata, this.request.getRefreshPolicy(), (Continuation<? super Unit>)$continuation);
                    ** if (v26 != var14_5) goto lbl154
lbl153:
                    // 1 sources

                    return var14_5;
lbl154:
                    // 1 sources

                    ** GOTO lbl163
                }
                case 5: {
                    updatedMetadata = (MonitorMetadata)$continuation.L$2;
                    indexResponse = (IndexResponse)$continuation.L$1;
                    this = (IndexMonitorHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v26 = $result;
lbl163:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = indexResponse;
                    $continuation.L$2 = null;
                    $continuation.label = 6;
                    v27 = MonitorMetadataService.INSTANCE.upsertMetadata(updatedMetadata, true, (Continuation<? super MonitorMetadata>)$continuation);
                    ** if (v27 != var14_5) goto lbl170
lbl169:
                    // 1 sources

                    return var14_5;
lbl170:
                    // 1 sources

                    ** GOTO lbl178
                }
                case 6: {
                    indexResponse = (IndexResponse)$continuation.L$1;
                    this = (IndexMonitorHandler)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v27 = $result;
lbl178:
                        // 4 sources

                        v28 = indexResponse.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"getId(...)");
                        this.actionListener.onResponse((Object)new IndexMonitorResponse(v28, indexResponse.getVersion(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), this.request.getMonitor()));
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"getFailures(...)");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexMonitorHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexMonitorHandler $this, boolean isAcknowledged) {
            $this.onCreateMappingsResponse(isAcknowledged);
        }

        public static final /* synthetic */ Client access$getClient$p(IndexMonitorHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexMonitorHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ Object access$updateMonitor(IndexMonitorHandler $this, Continuation $completion) {
            return $this.updateMonitor((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ void access$onSearchResponse(IndexMonitorHandler $this, SearchResponse response2) {
            $this.onSearchResponse(response2);
        }

        public static final /* synthetic */ Object access$indexMonitor(IndexMonitorHandler $this, Continuation $completion) {
            return $this.indexMonitor((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$cleanupMonitorAfterPartialFailure(IndexMonitorHandler $this, Monitor monitor, IndexResponse indexMonitorResponse2, Continuation $completion) {
            return $this.cleanupMonitorAfterPartialFailure(monitor, indexMonitorResponse2, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$indexDocLevelMonitorQueries(IndexMonitorHandler $this, Monitor monitor, String monitorId, MonitorMetadata monitorMetadata, WriteRequest.RefreshPolicy refreshPolicy, Continuation $completion) {
            return $this.indexDocLevelMonitorQueries(monitor, monitorId, monitorMetadata, refreshPolicy, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$onGetResponse(IndexMonitorHandler $this, Monitor currentMonitor, Continuation $completion) {
            return $this.onGetResponse(currentMonitor, (Continuation<? super Unit>)$completion);
        }
    }
}

