/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.serialize.json.v2;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.executor.IStateCoordinator;
import com.amazon.randomcutforest.executor.PointStoreCoordinator;
import com.amazon.randomcutforest.executor.SamplerPlusTree;
import com.amazon.randomcutforest.sampler.CompactSampler;
import com.amazon.randomcutforest.sampler.IStreamSampler;
import com.amazon.randomcutforest.sampler.Weighted;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.RandomCutForestState;
import com.amazon.randomcutforest.state.sampler.CompactSamplerMapper;
import com.amazon.randomcutforest.state.sampler.CompactSamplerState;
import com.amazon.randomcutforest.state.store.PointStoreState;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeContext;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.store.PointStore;
import com.amazon.randomcutforest.tree.ITree;
import com.amazon.randomcutforest.tree.RandomCutTree;
import com.amazon.randomcutforest.util.ArrayPacking;
import java.util.List;
import java.util.Random;

public class V2StateToV3ForestConverter {
    public RandomCutForest convert(RandomCutForestState v2State) {
        String version = v2State.getVersion();
        CommonUtils.checkArgument((version.equals("2.0") || version.equals("2.1") ? 1 : 0) != 0, (String)"incorrect convertor");
        if (Precision.valueOf((String)v2State.getPrecision()) == Precision.FLOAT_32) {
            RandomCutForestMapper mapper = new RandomCutForestMapper();
            mapper.setCompressionEnabled(v2State.isCompressed());
            return mapper.toModel(v2State);
        }
        return this.convertFrom64(v2State);
    }

    public PointStore convertFromDouble(PointStoreState state) {
        CommonUtils.checkNotNull((Object)state.getRefCount(), (String)"refCount must not be null");
        CommonUtils.checkNotNull((Object)state.getPointData(), (String)"pointData must not be null");
        CommonUtils.checkArgument((Precision.valueOf((String)state.getPrecision()) == Precision.FLOAT_64 ? 1 : 0) != 0, (String)("precision must be " + Precision.FLOAT_64));
        int indexCapacity = state.getIndexCapacity();
        int dimensions = state.getDimensions();
        float[] store = CommonUtils.toFloatArray((double[])ArrayPacking.unpackDoubles((byte[])state.getPointData(), (int)(state.getCurrentStoreCapacity() * dimensions)));
        int startOfFreeSegment = state.getStartOfFreeSegment();
        int[] refCount = ArrayPacking.unpackInts((int[])state.getRefCount(), (int)indexCapacity, (boolean)state.isCompressed());
        int[] locationList = new int[indexCapacity];
        int[] tempList = ArrayPacking.unpackInts((int[])state.getLocationList(), (boolean)state.isCompressed());
        System.arraycopy(tempList, 0, locationList, 0, tempList.length);
        if (!state.getVersion().equals("3.0")) {
            this.transformArray(locationList, dimensions / state.getShingleSize());
        }
        return PointStore.builder().internalRotationEnabled(state.isRotationEnabled()).internalShinglingEnabled(state.isInternalShinglingEnabled()).dynamicResizingEnabled(state.isDynamicResizingEnabled()).directLocationEnabled(state.isDirectLocationMap()).indexCapacity(indexCapacity).currentStoreCapacity(state.getCurrentStoreCapacity()).capacity(state.getCapacity()).shingleSize(state.getShingleSize()).dimensions(state.getDimensions()).locationList(locationList).nextTimeStamp(state.getLastTimeStamp()).startOfFreeSegment(startOfFreeSegment).refCount(refCount).knownShingle(state.getInternalShingle()).store(store).build();
    }

    void transformArray(int[] location, int baseDimension) {
        CommonUtils.checkArgument((baseDimension > 0 ? 1 : 0) != 0, (String)"incorrect invocation");
        for (int i = 0; i < location.length; ++i) {
            if (location[i] <= 0) continue;
            location[i] = location[i] / baseDimension;
        }
    }

    RandomCutForest convertFrom64(RandomCutForestState state) {
        boolean parallel = false;
        int threadPoolSize = 1;
        if (state.getExecutionContext() != null) {
            parallel = state.getExecutionContext().isParallelExecutionEnabled();
            threadPoolSize = state.getExecutionContext().getThreadPoolSize();
        }
        RandomCutForest.Builder builder = RandomCutForest.builder().numberOfTrees(state.getNumberOfTrees()).dimensions(state.getDimensions()).timeDecay(state.getTimeDecay()).sampleSize(state.getSampleSize()).centerOfMassEnabled(state.isCenterOfMassEnabled()).outputAfter(state.getOutputAfter()).parallelExecutionEnabled(parallel).threadPoolSize(threadPoolSize).storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled()).shingleSize(state.getShingleSize()).boundingBoxCacheFraction(state.getBoundingBoxCacheFraction()).compact(state.isCompact()).internalShinglingEnabled(state.isInternalShinglingEnabled());
        Random random = builder.getRandom();
        PointStore pointStore = this.convertFromDouble(state.getPointStoreState());
        ComponentList components = new ComponentList();
        PointStoreCoordinator coordinator = new PointStoreCoordinator((IPointStore)pointStore);
        coordinator.setTotalUpdates(state.getTotalUpdates());
        CompactRandomCutTreeContext context = new CompactRandomCutTreeContext();
        context.setPointStore((IPointStore)pointStore);
        context.setMaxSize(state.getSampleSize());
        CommonUtils.checkArgument((boolean)state.isSaveSamplerStateEnabled(), (String)" conversion cannot proceed without samplers");
        List samplerStates = state.getCompactSamplerStates();
        CompactSamplerMapper samplerMapper = new CompactSamplerMapper();
        for (int i = 0; i < state.getNumberOfTrees(); ++i) {
            CompactSampler compactData = (CompactSampler)samplerMapper.toModel((Object)((CompactSamplerState)samplerStates.get(i)));
            RandomCutTree tree = RandomCutTree.builder().capacity(state.getSampleSize()).pointStoreView((IPointStoreView)pointStore).storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled()).outputAfter(state.getOutputAfter()).centerOfMassEnabled(state.isCenterOfMassEnabled()).randomSeed(random.nextLong()).build();
            CompactSampler sampler = ((CompactSampler.Builder)((CompactSampler.Builder)((CompactSampler.Builder)CompactSampler.builder().capacity(state.getSampleSize())).timeDecay(state.getTimeDecay())).randomSeed(random.nextLong())).build();
            sampler.setMaxSequenceIndex(compactData.getMaxSequenceIndex());
            sampler.setMostRecentTimeDecayUpdate(compactData.getMostRecentTimeDecayUpdate());
            for (Weighted sample : compactData.getWeightedSample()) {
                Integer reference = (Integer)sample.getValue();
                Integer newReference = tree.addPoint(reference, sample.getSequenceIndex());
                if (newReference.intValue() != reference.intValue()) {
                    pointStore.incrementRefCount(newReference.intValue());
                    pointStore.decrementRefCount(reference.intValue());
                }
                sampler.addPoint(newReference, sample.getWeight(), sample.getSequenceIndex());
            }
            components.add((Object)new SamplerPlusTree((IStreamSampler)sampler, (ITree)tree));
        }
        RandomCutForest forest = new RandomCutForest(builder, (IStateCoordinator)coordinator, components, random);
        if (!state.isCurrentlySampling()) {
            forest.pauseSampling();
        }
        return forest;
    }
}

