/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.model;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.model.ForecastTask;
import org.opensearch.timeseries.TaskProfile;

public class ForecastTaskProfile
extends TaskProfile<ForecastTask> {
    public ForecastTaskProfile(ForecastTask forecastTask, Long rcfTotalUpdates, Long modelSizeInBytes, String nodeId, String taskId, String taskType) {
        super(forecastTask, rcfTotalUpdates, modelSizeInBytes, nodeId, taskId, taskType);
    }

    public ForecastTaskProfile(StreamInput input) throws IOException {
        this.task = input.readBoolean() ? new ForecastTask(input) : null;
        this.rcfTotalUpdates = input.readOptionalLong();
        this.modelSizeInBytes = input.readOptionalLong();
        this.nodeId = input.readOptionalString();
        this.taskId = input.readOptionalString();
        this.taskType = input.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.task != null) {
            out.writeBoolean(true);
            ((ForecastTask)this.task).writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalLong(this.rcfTotalUpdates);
        out.writeOptionalLong(this.modelSizeInBytes);
        out.writeOptionalString(this.nodeId);
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.taskType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        super.toXContent(xContentBuilder);
        return xContentBuilder.endObject();
    }

    public static ForecastTaskProfile parse(XContentParser parser) throws IOException {
        ForecastTask forecastTask = null;
        Long rcfTotalUpdates = null;
        Long modelSizeInBytes = null;
        String nodeId = null;
        String taskId = null;
        String taskType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "forecast_task": {
                    forecastTask = ForecastTask.parse(parser);
                    continue block16;
                }
                case "rcf_total_updates": {
                    rcfTotalUpdates = parser.longValue();
                    continue block16;
                }
                case "model_size_in_bytes": {
                    modelSizeInBytes = parser.longValue();
                    continue block16;
                }
                case "node_id": {
                    nodeId = parser.text();
                    continue block16;
                }
                case "task_id": {
                    taskId = parser.text();
                    continue block16;
                }
                case "task_type": {
                    taskType = parser.text();
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return new ForecastTaskProfile(forecastTask, rcfTotalUpdates, modelSizeInBytes, nodeId, taskId, taskType);
    }

    @Override
    protected String getTaskFieldName() {
        return "forecast_task";
    }
}

