/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.caching;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.timeseries.AnalysisModelSize;
import org.opensearch.timeseries.CleanState;
import org.opensearch.timeseries.MaintenanceState;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.ModelProfile;

public interface TimeSeriesCache<RCFModelType extends ThresholdedRandomCutForest>
extends MaintenanceState,
CleanState,
AnalysisModelSize {
    public boolean hostIfPossible(Config var1, ModelState<RCFModelType> var2);

    public Optional<ModelState<RCFModelType>> getForMaintainance(String var1, String var2);

    public ModelState<RCFModelType> get(String var1, Config var2);

    public boolean isActive(String var1, String var2);

    public long getTotalUpdates(String var1);

    public long getTotalUpdates(String var1, String var2);

    public List<ModelState<RCFModelType>> getAllModels();

    public List<ModelState<RCFModelType>> getAllModels(String var1);

    public int getActiveEntities(String var1);

    public int getTotalActiveEntities();

    public long getLastActiveTime(String var1, String var2);

    public void releaseMemoryForOpenCircuitBreaker();

    public Pair<List<Entity>, List<Entity>> selectUpdateCandidate(Collection<Entity> var1, String var2, Config var3);

    public List<ModelProfile> getAllModelProfile(String var1);

    public Optional<ModelProfile> getModelProfile(String var1, String var2);

    public void removeModel(String var1, String var2);

    default public long getRequiredMemoryPerEntity(Config config, MemoryTracker memoryTracker, int numberOfTrees) {
        int dimension = config.getEnabledFeatureIds().size() * config.getShingleSize();
        return memoryTracker.estimateTRCFModelSize(dimension, numberOfTrees, 0.0, config.getShingleSize(), 256);
    }

    default public long getTotalUpdates(ModelState<RCFModelType> modelState) {
        long accumulatedShingles = Optional.ofNullable(modelState).flatMap(model -> model.getModel()).map(trcf -> trcf.getForest()).map(rcf -> rcf.getTotalUpdates()).orElseGet(() -> Optional.ofNullable(modelState).map(model -> model.getSamples()).map(samples -> samples.size()).map(Long::valueOf).orElse(0L));
        return accumulatedShingles;
    }
}

