/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.TimeConfiguration;
import org.opensearch.timeseries.util.ParseUtils;

public class Job
implements Writeable,
ToXContentObject,
ScheduledJobParameter {
    public static final String PARSE_FIELD_NAME = "TimeSeriesJob";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Job.class, new ParseField("TimeSeriesJob", new String[0]), it -> Job.parse(it));
    public static final String NAME_FIELD = "name";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String LOCK_DURATION_SECONDS = "lock_duration_seconds";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String WINDOW_DELAY_FIELD = "window_delay";
    public static final String IS_ENABLED_FIELD = "enabled";
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    public static final String DISABLED_TIME_FIELD = "disabled_time";
    public static final String USER_FIELD = "user";
    private static final String RESULT_INDEX_FIELD = "result_index";
    private static final String TYPE_FIELD = "type";
    private final String name;
    private final Schedule schedule;
    private final TimeConfiguration windowDelay;
    private final Boolean isEnabled;
    private final Instant enabledTime;
    private final Instant disabledTime;
    private final Instant lastUpdateTime;
    private final Long lockDurationSeconds;
    private final User user;
    private String resultIndex;
    private AnalysisType analysisType;

    public Job(String name, Schedule schedule, TimeConfiguration windowDelay, Boolean isEnabled, Instant enabledTime, Instant disabledTime, Instant lastUpdateTime, Long lockDurationSeconds, User user, String resultIndex, AnalysisType type) {
        this.name = name;
        this.schedule = schedule;
        this.windowDelay = windowDelay;
        this.isEnabled = isEnabled;
        this.enabledTime = enabledTime;
        this.disabledTime = disabledTime;
        this.lastUpdateTime = lastUpdateTime;
        this.lockDurationSeconds = lockDurationSeconds;
        this.user = user;
        this.resultIndex = resultIndex;
        this.analysisType = type;
    }

    public Job(StreamInput input) throws IOException {
        this.name = input.readString();
        this.schedule = input.readEnum(ScheduleType.class) == ScheduleType.CRON ? new CronSchedule(input) : new IntervalSchedule(input);
        this.windowDelay = IntervalTimeConfiguration.readFrom(input);
        this.isEnabled = input.readBoolean();
        this.enabledTime = input.readInstant();
        this.disabledTime = input.readInstant();
        this.lastUpdateTime = input.readInstant();
        this.lockDurationSeconds = input.readLong();
        this.user = input.readBoolean() ? new User(input) : null;
        this.resultIndex = input.readOptionalString();
        this.analysisType = (AnalysisType)input.readEnum(AnalysisType.class);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(NAME_FIELD, this.name).field(SCHEDULE_FIELD, (ToXContent)this.schedule).field(WINDOW_DELAY_FIELD, (ToXContent)this.windowDelay).field(IS_ENABLED_FIELD, this.isEnabled).field(ENABLED_TIME_FIELD, this.enabledTime.toEpochMilli()).field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli()).field(LOCK_DURATION_SECONDS, this.lockDurationSeconds).field(TYPE_FIELD, (Object)this.analysisType);
        if (this.disabledTime != null) {
            xContentBuilder.field(DISABLED_TIME_FIELD, this.disabledTime.toEpochMilli());
        }
        if (this.user != null) {
            xContentBuilder.field(USER_FIELD, (ToXContent)this.user);
        }
        if (this.resultIndex != null) {
            xContentBuilder.field(RESULT_INDEX_FIELD, this.resultIndex);
        }
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.name);
        if (this.schedule instanceof CronSchedule) {
            output.writeEnum((Enum)ScheduleType.CRON);
        } else {
            output.writeEnum((Enum)ScheduleType.INTERVAL);
        }
        this.schedule.writeTo(output);
        this.windowDelay.writeTo(output);
        output.writeBoolean(this.isEnabled.booleanValue());
        output.writeInstant(this.enabledTime);
        output.writeInstant(this.disabledTime);
        output.writeInstant(this.lastUpdateTime);
        output.writeLong(this.lockDurationSeconds.longValue());
        if (this.user != null) {
            output.writeBoolean(true);
            this.user.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalString(this.resultIndex);
        output.writeEnum((Enum)this.analysisType);
    }

    public static Job parse(XContentParser parser) throws IOException {
        String name = null;
        Schedule schedule = null;
        TimeConfiguration windowDelay = null;
        Boolean isEnabled = Boolean.FALSE;
        Instant enabledTime = null;
        Instant disabledTime = null;
        Instant lastUpdateTime = null;
        Long lockDurationSeconds = 60L;
        User user = null;
        String resultIndex = null;
        String analysisType = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block26: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block26;
                }
                case "schedule": {
                    schedule = ScheduleParser.parse((XContentParser)parser);
                    continue block26;
                }
                case "window_delay": {
                    windowDelay = TimeConfiguration.parse(parser);
                    continue block26;
                }
                case "enabled": {
                    isEnabled = parser.booleanValue();
                    continue block26;
                }
                case "enabled_time": {
                    enabledTime = ParseUtils.toInstant(parser);
                    continue block26;
                }
                case "disabled_time": {
                    disabledTime = ParseUtils.toInstant(parser);
                    continue block26;
                }
                case "last_update_time": {
                    lastUpdateTime = ParseUtils.toInstant(parser);
                    continue block26;
                }
                case "lock_duration_seconds": {
                    lockDurationSeconds = parser.longValue();
                    continue block26;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block26;
                }
                case "result_index": {
                    resultIndex = parser.text();
                    continue block26;
                }
                case "type": {
                    analysisType = parser.text();
                    continue block26;
                }
            }
            parser.skipChildren();
        }
        return new Job(name, schedule, windowDelay, isEnabled, enabledTime, disabledTime, lastUpdateTime, lockDurationSeconds, user, resultIndex, Strings.isEmpty(analysisType) || AnalysisType.AD == AnalysisType.valueOf(analysisType) ? AnalysisType.AD : AnalysisType.FORECAST);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job that = (Job)o;
        return Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getSchedule(), (Object)that.getSchedule()) && Objects.equal((Object)this.isEnabled(), (Object)that.isEnabled()) && Objects.equal((Object)this.getEnabledTime(), (Object)that.getEnabledTime()) && Objects.equal((Object)this.getDisabledTime(), (Object)that.getDisabledTime()) && Objects.equal((Object)this.getLastUpdateTime(), (Object)that.getLastUpdateTime()) && Objects.equal((Object)this.getLockDurationSeconds(), (Object)that.getLockDurationSeconds()) && Objects.equal((Object)this.getCustomResultIndexOrAlias(), (Object)that.getCustomResultIndexOrAlias()) && Objects.equal((Object)((Object)this.getAnalysisType()), (Object)((Object)that.getAnalysisType()));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.schedule, this.isEnabled, this.enabledTime, this.lastUpdateTime, this.analysisType});
    }

    public String getName() {
        return this.name;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public TimeConfiguration getWindowDelay() {
        return this.windowDelay;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    public Instant getDisabledTime() {
        return this.disabledTime;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Long getLockDurationSeconds() {
        return this.lockDurationSeconds;
    }

    public User getUser() {
        return this.user;
    }

    public String getCustomResultIndexOrAlias() {
        return this.resultIndex;
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    static enum ScheduleType {
        CRON,
        INTERVAL;

    }
}

