/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.task;

import java.time.Instant;

public class RealtimeTaskCache {
    private String state;
    private Float initProgress;
    private String error;
    private long lastJobRunTime;
    private long intervalInMillis;

    public RealtimeTaskCache(String state, Float initProgress, String error, long detectorIntervalInMillis) {
        this.state = state;
        this.initProgress = initProgress;
        this.error = error;
        this.lastJobRunTime = Instant.now().toEpochMilli();
        this.intervalInMillis = detectorIntervalInMillis;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Float getInitProgress() {
        return this.initProgress;
    }

    public void setInitProgress(Float initProgress) {
        this.initProgress = initProgress;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setLastJobRunTime(long lastJobRunTime) {
        this.lastJobRunTime = lastJobRunTime;
    }

    public boolean expired() {
        return this.lastJobRunTime + 2L * this.intervalInMillis < Instant.now().toEpochMilli();
    }
}

