/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.executor;

import java.util.Optional;
import lombok.Generated;

public class UpdateResult<PointReference> {
    private static final UpdateResult<Object> NOOP = UpdateResult.builder().build();
    private final PointReference addedPoint;
    private final PointReference deletedPoint;

    public static <Q> UpdateResult<Q> noop() {
        return NOOP;
    }

    public Optional<PointReference> getAddedPoint() {
        return Optional.ofNullable(this.addedPoint);
    }

    public Optional<PointReference> getDeletedPoint() {
        return Optional.ofNullable(this.deletedPoint);
    }

    public boolean isStateChange() {
        return this.addedPoint != null || this.deletedPoint != null;
    }

    @Generated
    UpdateResult(PointReference addedPoint, PointReference deletedPoint) {
        this.addedPoint = addedPoint;
        this.deletedPoint = deletedPoint;
    }

    @Generated
    public static <PointReference> UpdateResultBuilder<PointReference> builder() {
        return new UpdateResultBuilder();
    }

    @Generated
    public static class UpdateResultBuilder<PointReference> {
        @Generated
        private PointReference addedPoint;
        @Generated
        private PointReference deletedPoint;

        @Generated
        UpdateResultBuilder() {
        }

        @Generated
        public UpdateResultBuilder<PointReference> addedPoint(PointReference addedPoint) {
            this.addedPoint = addedPoint;
            return this;
        }

        @Generated
        public UpdateResultBuilder<PointReference> deletedPoint(PointReference deletedPoint) {
            this.deletedPoint = deletedPoint;
            return this;
        }

        @Generated
        public UpdateResult<PointReference> build() {
            return new UpdateResult<PointReference>(this.addedPoint, this.deletedPoint);
        }

        @Generated
        public String toString() {
            return "UpdateResult.UpdateResultBuilder(addedPoint=" + this.addedPoint + ", deletedPoint=" + this.deletedPoint + ")";
        }
    }
}

