/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.util;

import com.amazon.randomcutforest.CommonUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ArrayPacking {
    public static int logMax(long base) {
        CommonUtils.checkArgument(base > 1L, "Absolute value of base must be greater than 1");
        int pack = 0;
        long num = base;
        while (num < Integer.MAX_VALUE) {
            num *= base;
            ++pack;
        }
        return Math.max(pack, 1);
    }

    public static int[] pack(int[] inputArray, boolean compress) {
        return ArrayPacking.pack(inputArray, inputArray.length, compress);
    }

    public static int[] pack(int[] inputArray, int length, boolean compress) {
        CommonUtils.checkNotNull(inputArray, "inputArray must not be null");
        CommonUtils.checkArgument(0 <= length && length <= inputArray.length, "length must be between 0 and inputArray.length (inclusive)");
        if (!compress || length < 3) {
            return Arrays.copyOf(inputArray, length);
        }
        int min = inputArray[0];
        int max = inputArray[0];
        for (int i = 1; i < length; ++i) {
            min = Math.min(min, inputArray[i]);
            max = Math.max(max, inputArray[i]);
        }
        long base = (long)max - (long)min + 1L;
        if (base == 1L) {
            return new int[]{min, max, length};
        }
        int packNum = ArrayPacking.logMax(base);
        int[] output = new int[3 + (int)Math.ceil(1.0 * (double)length / (double)packNum)];
        output[0] = min;
        output[1] = max;
        output[2] = length;
        int used = 0;
        for (int len = 0; len < length; len += packNum) {
            int reach;
            long code = 0L;
            for (int i = reach = Math.min(len + packNum - 1, length - 1); i >= len; --i) {
                code = base * code + (long)(inputArray[i] - min);
            }
            output[3 + used++] = (int)code;
        }
        return output;
    }

    public static int[] pack(short[] inputArray, boolean compress) {
        return ArrayPacking.pack(inputArray, inputArray.length, compress);
    }

    public static int[] pack(short[] inputArray, int length, boolean compress) {
        CommonUtils.checkNotNull(inputArray, "inputArray must not be null");
        CommonUtils.checkArgument(0 <= length && length <= inputArray.length, "length must be between 0 and inputArray.length (inclusive)");
        if (!compress || length < 3) {
            int[] ret = new int[length];
            for (int i = 0; i < length; ++i) {
                ret[i] = inputArray[i];
            }
            return ret;
        }
        int min = inputArray[0];
        int max = inputArray[0];
        for (int i = 1; i < length; ++i) {
            min = Math.min(min, inputArray[i]);
            max = Math.max(max, inputArray[i]);
        }
        long base = (long)max - (long)min + 1L;
        if (base == 1L) {
            return new int[]{min, max, length};
        }
        int packNum = ArrayPacking.logMax(base);
        int[] output = new int[3 + (int)Math.ceil(1.0 * (double)length / (double)packNum)];
        output[0] = min;
        output[1] = max;
        output[2] = length;
        int used = 0;
        for (int len = 0; len < length; len += packNum) {
            int reach;
            long code = 0L;
            for (int i = reach = Math.min(len + packNum - 1, length - 1); i >= len; --i) {
                code = base * code + (long)(inputArray[i] - min);
            }
            output[3 + used++] = (int)code;
        }
        return output;
    }

    public static int[] unpackInts(int[] packedArray, boolean decompress) {
        CommonUtils.checkNotNull(packedArray, " array unpacking invoked on null arrays");
        if (!decompress) {
            return Arrays.copyOf(packedArray, packedArray.length);
        }
        return packedArray.length < 3 ? ArrayPacking.unpackInts(packedArray, packedArray.length, decompress) : ArrayPacking.unpackInts(packedArray, packedArray[2], decompress);
    }

    public static int[] unpackInts(int[] packedArray, int length, boolean decompress) {
        CommonUtils.checkNotNull(packedArray, " array unpacking invoked on null arrays");
        CommonUtils.checkArgument(length >= 0, "incorrect length parameter");
        if (packedArray.length < 3 || !decompress) {
            return Arrays.copyOf(packedArray, length);
        }
        int min = packedArray[0];
        int max = packedArray[1];
        int[] output = new int[length];
        if (min == max) {
            if (packedArray[2] >= length) {
                Arrays.fill(output, min);
            } else {
                for (int i = 0; i < packedArray[2]; ++i) {
                    output[i] = min;
                }
            }
        } else {
            long base = (long)max - (long)min + 1L;
            int packNum = ArrayPacking.logMax(base);
            int count = 0;
            for (int i = 3; i < packedArray.length; ++i) {
                long code = packedArray[i];
                for (int j = 0; j < packNum && count < Math.min(packedArray[2], length); ++j) {
                    output[count++] = (int)((long)min + code % base);
                    code = (int)(code / base);
                }
            }
        }
        return output;
    }

    private static short[] copyToShort(int[] array, int length) {
        short[] ret = new short[length];
        for (int i = 0; i < Math.min(length, array.length); ++i) {
            ret[i] = (short)array[i];
        }
        return ret;
    }

    public static short[] unpackShorts(int[] packedArray, boolean decompress) {
        CommonUtils.checkNotNull(packedArray, " array unpacking invoked on null arrays");
        if (!decompress) {
            return ArrayPacking.copyToShort(packedArray, packedArray.length);
        }
        return packedArray.length < 3 ? ArrayPacking.unpackShorts(packedArray, packedArray.length, decompress) : ArrayPacking.unpackShorts(packedArray, packedArray[2], decompress);
    }

    public static short[] unpackShorts(int[] packedArray, int length, boolean decompress) {
        CommonUtils.checkNotNull(packedArray, " array unpacking invoked on null arrays");
        CommonUtils.checkArgument(length >= 0, "incorrect length parameter");
        if (packedArray.length < 3 || !decompress) {
            return ArrayPacking.copyToShort(packedArray, length);
        }
        int min = packedArray[0];
        int max = packedArray[1];
        short[] output = new short[length];
        if (min == max) {
            if (packedArray[2] >= length) {
                Arrays.fill(output, (short)min);
            } else {
                for (int i = 0; i < packedArray[2]; ++i) {
                    output[i] = (short)min;
                }
            }
        } else {
            long base = (long)max - (long)min + 1L;
            int packNum = ArrayPacking.logMax(base);
            int count = 0;
            for (int i = 3; i < packedArray.length; ++i) {
                long code = packedArray[i];
                for (int j = 0; j < packNum && count < Math.min(packedArray[2], length); ++j) {
                    output[count++] = (short)((long)min + code % base);
                    code = (int)(code / base);
                }
            }
        }
        return output;
    }

    public static byte[] pack(double[] array) {
        CommonUtils.checkNotNull(array, "array must not be null");
        return ArrayPacking.pack(array, array.length);
    }

    public static byte[] pack(double[] array, int length) {
        CommonUtils.checkNotNull(array, "array must not be null");
        CommonUtils.checkArgument(0 <= length, "incorrect length parameter");
        CommonUtils.checkArgument(length <= array.length, "length must be between 0 and inputArray.length (inclusive)");
        ByteBuffer buf = ByteBuffer.allocate(length * 8);
        for (int i = 0; i < length; ++i) {
            buf.putDouble(array[i]);
        }
        return buf.array();
    }

    public static byte[] pack(float[] array) {
        CommonUtils.checkNotNull(array, "array must not be null");
        return ArrayPacking.pack(array, array.length);
    }

    public static byte[] pack(float[] array, int length) {
        CommonUtils.checkArgument(0 <= length, "incorrect length parameter");
        CommonUtils.checkArgument(length <= array.length, "length must be between 0 and inputArray.length (inclusive)");
        ByteBuffer buf = ByteBuffer.allocate(length * 4);
        for (int i = 0; i < length; ++i) {
            buf.putFloat(array[i]);
        }
        return buf.array();
    }

    public static double[] unpackDoubles(byte[] bytes) {
        CommonUtils.checkNotNull(bytes, "bytes must not be null");
        return ArrayPacking.unpackDoubles(bytes, bytes.length / 8);
    }

    public static double[] unpackDoubles(byte[] bytes, int length) {
        CommonUtils.checkNotNull(bytes, "bytes must not be null");
        CommonUtils.checkArgument(length >= 0, "length must be greater than or equal to 0");
        CommonUtils.checkArgument(bytes.length % 8 == 0, "bytes.length must be divisible by Double.BYTES");
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        double[] result = new double[length];
        int m = Math.min(length, bytes.length / 8);
        for (int i = 0; i < m; ++i) {
            result[i] = buf.getDouble();
        }
        return result;
    }

    public static float[] unpackFloats(byte[] bytes) {
        CommonUtils.checkNotNull(bytes, "bytes must not be null");
        return ArrayPacking.unpackFloats(bytes, bytes.length / 4);
    }

    public static float[] unpackFloats(byte[] bytes, int length) {
        CommonUtils.checkNotNull(bytes, "bytes must not be null");
        CommonUtils.checkArgument(length >= 0, "length must be greater than or equal to 0");
        CommonUtils.checkArgument(bytes.length % 4 == 0, "bytes.length must be divisible by Float.BYTES");
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        float[] result = new float[length];
        int m = Math.min(length, bytes.length / 4);
        for (int i = 0; i < m; ++i) {
            result[i] = buf.getFloat();
        }
        return result;
    }
}

