/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context.persistence;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContext;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.persistence.AsynchronousSearchPersistenceModel;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchState;

public class AsynchronousSearchPersistenceContext
extends AsynchronousSearchContext {
    private static final Logger logger = LogManager.getLogger(AsynchronousSearchPersistenceContext.class);
    private final String asynchronousSearchId;
    private final AsynchronousSearchPersistenceModel asynchronousSearchPersistenceModel;
    private final NamedWriteableRegistry namedWriteableRegistry;

    public AsynchronousSearchPersistenceContext(String asynchronousSearchId, AsynchronousSearchContextId asynchronousSearchContextId, AsynchronousSearchPersistenceModel asynchronousSearchPersistenceModel, LongSupplier currentTimeSupplier, NamedWriteableRegistry namedWriteableRegistry) {
        super(asynchronousSearchContextId, currentTimeSupplier);
        Objects.requireNonNull(asynchronousSearchId);
        Objects.requireNonNull(asynchronousSearchContextId);
        Objects.requireNonNull(asynchronousSearchPersistenceModel);
        this.asynchronousSearchId = asynchronousSearchId;
        this.asynchronousSearchPersistenceModel = asynchronousSearchPersistenceModel;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    public AsynchronousSearchPersistenceModel getAsynchronousSearchPersistenceModel() {
        return this.asynchronousSearchPersistenceModel;
    }

    @Override
    public String getAsynchronousSearchId() {
        return this.asynchronousSearchId;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public long getExpirationTimeMillis() {
        return this.asynchronousSearchPersistenceModel.getExpirationTimeMillis();
    }

    @Override
    public long getStartTimeMillis() {
        return this.asynchronousSearchPersistenceModel.getStartTimeMillis();
    }

    @Override
    public SearchResponse getSearchResponse() {
        SearchResponse searchResponse;
        if (this.asynchronousSearchPersistenceModel.getResponse() == null) {
            return null;
        }
        BytesReference bytesReference = BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(Base64.getUrlDecoder().decode(this.asynchronousSearchPersistenceModel.getResponse())));
        NamedWriteableAwareStreamInput wrapperStreamInput = new NamedWriteableAwareStreamInput(bytesReference.streamInput(), this.namedWriteableRegistry);
        try {
            wrapperStreamInput.setVersion(wrapperStreamInput.readVersion());
            searchResponse = new SearchResponse((StreamInput)wrapperStreamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    wrapperStreamInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error(() -> new ParameterizedMessage("Failed to parse search response for asynchronous search [{}] Response : [{}] ", (Object)this.asynchronousSearchId, (Object)this.asynchronousSearchPersistenceModel.getResponse()), (Throwable)e);
                return null;
            }
        }
        wrapperStreamInput.close();
        return searchResponse;
    }

    @Override
    public Exception getSearchError() {
        Exception exception;
        if (this.asynchronousSearchPersistenceModel.getError() == null) {
            return null;
        }
        BytesReference bytesReference = BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(Base64.getUrlDecoder().decode(this.asynchronousSearchPersistenceModel.getError())));
        NamedWriteableAwareStreamInput wrapperStreamInput = new NamedWriteableAwareStreamInput(bytesReference.streamInput(), this.namedWriteableRegistry);
        try {
            wrapperStreamInput.setVersion(wrapperStreamInput.readVersion());
            exception = wrapperStreamInput.readException();
        }
        catch (Throwable throwable) {
            try {
                try {
                    wrapperStreamInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error(() -> new ParameterizedMessage("Failed to parse search error for asynchronous search [{}] Error : [{}] ", (Object)this.asynchronousSearchId, (Object)this.asynchronousSearchPersistenceModel.getResponse()), (Throwable)e);
                return null;
            }
        }
        wrapperStreamInput.close();
        return exception;
    }

    @Override
    public User getUser() {
        return this.asynchronousSearchPersistenceModel.getUser();
    }

    @Override
    public AsynchronousSearchState getAsynchronousSearchState() {
        return AsynchronousSearchState.STORE_RESIDENT;
    }

    public int hashCode() {
        return Objects.hash(this.asynchronousSearchId, this.asynchronousSearchPersistenceModel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsynchronousSearchPersistenceContext asynchronousSearchPersistenceContext = (AsynchronousSearchPersistenceContext)o;
        return asynchronousSearchPersistenceContext.getAsynchronousSearchId().equals(this.asynchronousSearchId) && asynchronousSearchPersistenceContext.getAsynchronousSearchPersistenceModel().equals(this.asynchronousSearchPersistenceModel);
    }
}

