/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.repository;

import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.commons.utils.OpenForTesting;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.replication.repository.RestoreContext;
import org.opensearch.replication.util.ExtensionsKt;

@OpenForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 '2\u00020\u0001:\u0001'B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003J#\u0010#\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0%H\u0010\u00a2\u0006\u0002\b&R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/opensearch/replication/repository/RestoreContext;", "Ljava/io/Closeable;", "restoreUUID", "", "shard", "Lorg/opensearch/index/shard/IndexShard;", "indexCommitRef", "Lorg/opensearch/common/concurrent/GatedCloseable;", "Lorg/apache/lucene/index/IndexCommit;", "metadataSnapshot", "Lorg/opensearch/index/store/Store$MetadataSnapshot;", "replayOperationsFrom", "", "(Ljava/lang/String;Lorg/opensearch/index/shard/IndexShard;Lorg/opensearch/common/concurrent/GatedCloseable;Lorg/opensearch/index/store/Store$MetadataSnapshot;J)V", "currentFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/apache/lucene/store/IndexInput;", "fileLocks", "Ljava/util/concurrent/locks/ReentrantLock;", "getIndexCommitRef", "()Lorg/opensearch/common/concurrent/GatedCloseable;", "getMetadataSnapshot", "()Lorg/opensearch/index/store/Store$MetadataSnapshot;", "getReplayOperationsFrom", "()J", "getRestoreUUID", "()Ljava/lang/String;", "getShard", "()Lorg/opensearch/index/shard/IndexShard;", "close", "", "openInput", "store", "Lorg/opensearch/index/store/Store;", "fileName", "withStoreReference", "block", "Lkotlin/Function0;", "withStoreReference$opensearch_cross_cluster_replication", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nRestoreContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestoreContext.kt\norg/opensearch/replication/repository/RestoreContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1#2:74\n1855#3,2:75\n*S KotlinDebug\n*F\n+ 1 RestoreContext.kt\norg/opensearch/replication/repository/RestoreContext\n*L\n62#1:75,2\n*E\n"})
public class RestoreContext
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String restoreUUID;
    @NotNull
    private final IndexShard shard;
    @NotNull
    private final GatedCloseable<IndexCommit> indexCommitRef;
    @NotNull
    private final Store.MetadataSnapshot metadataSnapshot;
    private final long replayOperationsFrom;
    @NotNull
    private final ConcurrentHashMap<String, IndexInput> currentFiles;
    @NotNull
    private final ConcurrentHashMap<String, ReentrantLock> fileLocks;
    private static final int INITIAL_FILE_CACHE_CAPACITY = 20;

    public RestoreContext(@NotNull String restoreUUID, @NotNull IndexShard shard, @NotNull GatedCloseable<IndexCommit> indexCommitRef, @NotNull Store.MetadataSnapshot metadataSnapshot, long replayOperationsFrom) {
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter((Object)shard, (String)"shard");
        Intrinsics.checkNotNullParameter(indexCommitRef, (String)"indexCommitRef");
        Intrinsics.checkNotNullParameter((Object)metadataSnapshot, (String)"metadataSnapshot");
        this.restoreUUID = restoreUUID;
        this.shard = shard;
        this.indexCommitRef = indexCommitRef;
        this.metadataSnapshot = metadataSnapshot;
        this.replayOperationsFrom = replayOperationsFrom;
        this.currentFiles = new ConcurrentHashMap(20);
        this.fileLocks = new ConcurrentHashMap();
    }

    @NotNull
    public final String getRestoreUUID() {
        return this.restoreUUID;
    }

    @NotNull
    public final IndexShard getShard() {
        return this.shard;
    }

    @NotNull
    public final GatedCloseable<IndexCommit> getIndexCommitRef() {
        return this.indexCommitRef;
    }

    @NotNull
    public final Store.MetadataSnapshot getMetadataSnapshot() {
        return this.metadataSnapshot;
    }

    public final long getReplayOperationsFrom() {
        return this.replayOperationsFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IndexInput openInput(@NotNull Store store, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ReentrantLock reentrantLock = this.fileLocks.computeIfAbsent(fileName, arg_0 -> RestoreContext.openInput$lambda$0(openInput.lock.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)reentrantLock, (String)"computeIfAbsent(...)");
        ReentrantLock lock2 = reentrantLock;
        Lock lock3 = lock2;
        lock3.lock();
        try {
            boolean bl = false;
            Ref.ObjectRef baseInput = new Ref.ObjectRef();
            this.withStoreReference$opensearch_cross_cluster_replication(store, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<IndexInput>)baseInput, this, fileName, store){
                final /* synthetic */ Ref.ObjectRef<IndexInput> $baseInput;
                final /* synthetic */ RestoreContext this$0;
                final /* synthetic */ String $fileName;
                final /* synthetic */ Store $store;
                {
                    this.$baseInput = $baseInput;
                    this.this$0 = $receiver;
                    this.$fileName = $fileName;
                    this.$store = $store;
                    super(0);
                }

                public final void invoke() {
                    this.$baseInput.element = RestoreContext.access$getCurrentFiles$p(this.this$0).computeIfAbsent(this.$fileName, arg_0 -> openInput.1.1.invoke$lambda$0((Function1)new Function1<String, IndexInput>(this.$store, this.$fileName){
                        final /* synthetic */ Store $store;
                        final /* synthetic */ String $fileName;
                        {
                            this.$store = $store;
                            this.$fileName = $fileName;
                            super(1);
                        }

                        @NotNull
                        public final IndexInput invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.$store.directory().openInput(this.$fileName, IOContext.DEFAULT);
                        }
                    }, arg_0));
                }

                private static final IndexInput invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (IndexInput)$tmp0.invoke(p0);
                }
            }));
            Object object = baseInput.element;
            if (object == null) {
                boolean bl2 = false;
                String string = "[RestoreContext] IndexInput file must not be null";
                throw new IllegalStateException(string.toString());
            }
            IndexInput indexInput = ((IndexInput)object).clone();
            Intrinsics.checkNotNullExpressionValue((Object)indexInput, (String)"clone(...)");
            IndexInput indexInput2 = indexInput;
            return indexInput2;
        }
        finally {
            lock3.unlock();
        }
    }

    public void withStoreReference$opensearch_cross_cluster_replication(@NotNull Store store, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ExtensionsKt.performOp$default(store, block, null, 2, null);
    }

    @Override
    public void close() {
        Collection<IndexInput> collection = this.currentFiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexInput it = (IndexInput)element$iv;
            boolean bl = false;
            it.close();
        }
        this.currentFiles.clear();
        this.fileLocks.clear();
        this.indexCommitRef.close();
    }

    private static final ReentrantLock openInput$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ReentrantLock)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getCurrentFiles$p(RestoreContext $this) {
        return $this.currentFiles;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/replication/repository/RestoreContext$Companion;", "", "()V", "INITIAL_FILE_CACHE_CAPACITY", "", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

