function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiI18n } from '../i18n';
import { getDetailsForSchema } from './data_grid_schema';
import { defaultSortAscLabel, defaultSortDescLabel } from './column_sorting_draggable';
export function getColumnActions(column, columns, schema, schemaDetectors, setVisibleColumns, setIsPopoverOpen, sorting, switchColumnPos) {
  var _column$actions, _column$actions3, _column$actions5, _column$actions7, _column$actions9, _column$actions1, _column$actions10;
  if (column.actions === false) {
    return [];
  }
  var colIdx = columns.findIndex(function (col) {
    return col.id === column.id;
  });
  var sortingIdx = sorting ? sorting.columns.findIndex(function (col) {
    return col.id === column.id;
  }) : -1;
  var sortBy = function sortBy() {
    var _sorting$columns$sort;
    var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
    if (!sorting) {
      return;
    }
    if (sortingIdx >= 0 && ((_sorting$columns$sort = sorting.columns[sortingIdx]) === null || _sorting$columns$sort === void 0 ? void 0 : _sorting$columns$sort.direction) === direction) {
      // unsort if the same current and new direction are same
      var newColumns = sorting.columns.filter(function (val, idx) {
        return idx !== sortingIdx;
      });
      sorting.onSort(newColumns);
    } else if (sortingIdx >= 0) {
      // replace existing sort
      var _newColumns = Object.values(_objectSpread(_objectSpread({}, sorting.columns), {}, _defineProperty({}, sortingIdx, {
        id: column.id,
        direction: direction
      })));
      sorting.onSort(_newColumns);
    } else {
      // add new sort
      var _newColumns2 = [].concat(_toConsumableArray(sorting.columns), [{
        id: column.id,
        direction: direction
      }]);
      sorting.onSort(_newColumns2);
    }
  };
  var onClickHideColumn = function onClickHideColumn() {
    return setVisibleColumns(columns.filter(function (col) {
      return col.id !== column.id;
    }).map(function (col) {
      return col.id;
    }));
  };
  var onClickSortAsc = function onClickSortAsc() {
    sortBy('asc');
  };
  var onClickSortDesc = function onClickSortDesc() {
    sortBy('desc');
  };
  var onClickMoveLeft = function onClickMoveLeft() {
    var targetCol = columns[colIdx - 1];
    if (targetCol) {
      switchColumnPos(column.id, targetCol.id);
    }
  };
  var onClickMoveRight = function onClickMoveRight() {
    var targetCol = columns[colIdx + 1];
    if (targetCol) {
      switchColumnPos(column.id, targetCol.id);
    }
  };
  var result = [];
  if (((_column$actions = column.actions) === null || _column$actions === void 0 ? void 0 : _column$actions.showHide) !== false) {
    var _column$actions2;
    var option = {
      label: /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiColumnActions.hideColumn",
        default: "Hide column"
      }),
      onClick: onClickHideColumn,
      iconType: 'eyeClosed',
      size: 'xs',
      color: 'text'
    };
    if (_typeof((_column$actions2 = column.actions) === null || _column$actions2 === void 0 ? void 0 : _column$actions2.showHide) === 'object') {
      result.push(_objectSpread(_objectSpread({}, option), column.actions.showHide));
    } else {
      result.push(option);
    }
  }
  var schemaDetails = schema.hasOwnProperty(column.id) && schema[column.id].columnType != null ? getDetailsForSchema(schemaDetectors, schema[column.id].columnType) : null;
  if (((_column$actions3 = column.actions) === null || _column$actions3 === void 0 ? void 0 : _column$actions3.showSortAsc) !== false && sorting) {
    var _column$actions4;
    var label = schemaDetails ? schemaDetails.sortTextAsc : defaultSortAscLabel;
    var _option = {
      label: /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiColumnActions.sort",
        default: "Sort {schemaLabel}",
        values: {
          schemaLabel: label
        }
      }),
      onClick: onClickSortAsc,
      isDisabled: column.isSortable === false,
      className: sortingIdx >= 0 && sorting.columns[sortingIdx].direction === 'asc' ? 'euiDataGridHeader__action--selected' : '',
      iconType: 'sortUp',
      size: 'xs',
      color: 'text'
    };
    if (_typeof((_column$actions4 = column.actions) === null || _column$actions4 === void 0 ? void 0 : _column$actions4.showSortAsc) === 'object') {
      result.push(_objectSpread(_objectSpread({}, _option), column.actions.showSortAsc));
    } else {
      result.push(_option);
    }
  }
  if (((_column$actions5 = column.actions) === null || _column$actions5 === void 0 ? void 0 : _column$actions5.showSortDesc) !== false && sorting) {
    var _column$actions6;
    var _label = schemaDetails ? schemaDetails.sortTextDesc : defaultSortDescLabel;
    var _option2 = {
      label: /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiColumnActions.sort",
        default: "Sort {schemaLabel}",
        values: {
          schemaLabel: _label
        }
      }),
      onClick: onClickSortDesc,
      isDisabled: column.isSortable === false,
      className: sortingIdx >= 0 && sorting.columns[sortingIdx].direction === 'desc' ? 'euiDataGridHeader__action--selected' : '',
      iconType: 'sortDown',
      size: 'xs',
      color: 'text'
    };
    if (_typeof((_column$actions6 = column.actions) === null || _column$actions6 === void 0 ? void 0 : _column$actions6.showSortDesc) === 'object') {
      result.push(_objectSpread(_objectSpread({}, _option2), column.actions.showSortDesc));
    } else {
      result.push(_option2);
    }
  }
  if (((_column$actions7 = column.actions) === null || _column$actions7 === void 0 ? void 0 : _column$actions7.showMoveLeft) !== false) {
    var _column$actions8;
    var _option3 = {
      label: /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiColumnActions.moveLeft",
        default: "Move left"
      }),
      iconType: 'sortLeft',
      size: 'xs',
      color: 'text',
      onClick: onClickMoveLeft,
      isDisabled: colIdx === 0
    };
    if (_typeof((_column$actions8 = column.actions) === null || _column$actions8 === void 0 ? void 0 : _column$actions8.showMoveLeft) === 'object') {
      result.push(_objectSpread(_objectSpread({}, _option3), column.actions.showMoveLeft));
    } else {
      result.push(_option3);
    }
  }
  if (((_column$actions9 = column.actions) === null || _column$actions9 === void 0 ? void 0 : _column$actions9.showMoveRight) !== false) {
    var _column$actions0;
    var _option4 = {
      label: /*#__PURE__*/React.createElement(EuiI18n, {
        token: "euiColumnActions.moveRight",
        default: "Move right"
      }),
      iconType: 'sortRight',
      size: 'xs',
      color: 'text',
      onClick: onClickMoveRight,
      isDisabled: colIdx === columns.length - 1
    };
    if (_typeof((_column$actions0 = column.actions) === null || _column$actions0 === void 0 ? void 0 : _column$actions0.showMoveRight) === 'object') {
      result.push(_objectSpread(_objectSpread({}, _option4), column.actions.showMoveRight));
    } else {
      result.push(_option4);
    }
  }
  var allActions = ((_column$actions1 = column.actions) === null || _column$actions1 === void 0 ? void 0 : _column$actions1.additional) ? [].concat(result, _toConsumableArray((_column$actions10 = column.actions) === null || _column$actions10 === void 0 ? void 0 : _column$actions10.additional)) : result;

  //wrap EuiListGroupItem onClick function to close the popover and prevet bubbling up

  return allActions.map(function (action) {
    return _objectSpread(_objectSpread({}, action), {
      onClick: function onClick(ev) {
        ev.stopPropagation();
        setIsPopoverOpen(false);
        if (action && action.onClick) {
          action.onClick(ev);
        }
      }
    });
  });
}