"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    managedIndexService
  } = services;
  router.get({
    path: _constants.NODE_API.MANAGED_INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.getManagedIndices);
  router.get({
    path: `${_constants.NODE_API.MANAGED_INDICES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.getManagedIndex);
  router.post({
    path: _constants.NODE_API.RETRY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.retryManagedIndexPolicy);
  router.post({
    path: _constants.NODE_API.CHANGE_POLICY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.changePolicy);
  router.post({
    path: _constants.NODE_API.REMOVE_POLICY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, managedIndexService.removePolicy);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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