"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../utils/constants");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    snapshotManagementService
  } = services;
  router.get({
    path: _constants.NODE_API._SNAPSHOTS,
    validate: {
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getAllSnapshotsWithPolicy);
  router.get({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getSnapshot);
  router.delete({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.deleteSnapshot);
  router.put({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createSnapshot);
  router.post({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.restoreSnapshot);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.createPolicy);
  router.put({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number()),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.updatePolicy);
  router.get({
    path: _constants.NODE_API.SMPolicies,
    validate: {
      // for public service to pass object to server service
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        sortField: _configSchema.schema.string(),
        sortOrder: _configSchema.schema.string(),
        queryString: _configSchema.schema.string(),
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getPolicies);
  router.get({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getPolicy);
  router.delete({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.deletePolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.startPolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.stopPolicy);
  router.get({
    path: _constants.NODE_API._REPOSITORIES,
    validate: {
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.catRepositoriesWithSnapshotCount);
  router.get({
    path: `${_constants.NODE_API._INDICES}/{indices}`,
    validate: {
      params: _configSchema.schema.object({
        indices: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.catSnapshotIndices);
  router.get({
    path: _constants.NODE_API._RECOVERY,
    validate: {
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getIndexRecovery);
  router.delete({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.deleteRepository);
  router.get({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.getRepository);
  router.put({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        ...(dataSourceEnabled ? {
          dataSourceId: _configSchema.schema.string()
        } : {})
      })
    }
  }, snapshotManagementService.createRepository);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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