"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Aggregations = void 0;
var _lodash = require("lodash");
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class Aggregations extends _node.PPLNode {
  constructor(name, children, partitions, allNum, delim, aggExprList, groupExprList, dedupSplitValue, indices) {
    super(name, children);
    this.partitions = partitions;
    this.allNum = allNum;
    this.delim = delim;
    this.aggExprList = aggExprList;
    this.groupExprList = groupExprList;
    this.dedupSplitValue = dedupSplitValue;
    this.indices = indices;
  }
  getStartEndIndicesOfOriginQuery() {
    if (this.indices === undefined) {
      return {
        start: -1,
        end: -1
      };
    }
    return {
      start: this.indices.start,
      end: this.indices.end
    };
  }
  getTokens() {
    return {
      partitions: this.partitions,
      all_num: this.allNum,
      delim: this.delim,
      aggregations: this.aggExprList.map(aggTerm => aggTerm.getTokens()),
      groupby: !(0, _lodash.isEmpty)(this.groupExprList) ? this.groupExprList.getTokens() : '',
      dedup_split_value: this.dedupSplitValue
    };
  }
  toString() {
    return `stats ${!(0, _lodash.isEmpty)(this.partitions) ? `${this.partitions} ` : ''}${!(0, _lodash.isEmpty)(this.allNum) ? `${this.allNum} ` : ''}${!(0, _lodash.isEmpty)(this.delim) ? `${this.delim} ` : ''}${this.aggExprList.map(aggTerm => aggTerm.toString()).join(', ')}${!(0, _lodash.isEmpty)(this.groupExprList) ? ` ${this.groupExprList.toString()}` : ''}${!(0, _lodash.isEmpty)(this.dedupSplitValue) ? ` ${this.dedupSplitValue}` : ''}`;
  }
}
exports.Aggregations = Aggregations;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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