"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.opensearch_reports = components.clientAction.namespaceFactory();
  const opensearchReports = Client.prototype.opensearch_reports.prototype;

  /**
   * report related APIs
   */
  opensearchReports.createReport = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.ON_DEMAND_REPORT}`
    },
    method: 'PUT',
    needBody: true
  });
  opensearchReports.createReportFromDefinition = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.ON_DEMAND_REPORT}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST',
    needBody: true
  });
  opensearchReports.updateReportInstanceStatus = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_INSTANCE}/<%=reportInstanceId%>`,
      req: {
        reportInstanceId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST',
    needBody: true
  });
  opensearchReports.getReportById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_INSTANCE}/<%=reportInstanceId%>`,
      req: {
        reportInstanceId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  opensearchReports.getReports = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.LIST_REPORT_INSTANCES}`,
      params: {
        fromIndex: {
          type: 'number'
        },
        maxItems: {
          type: 'number'
        }
      }
    },
    method: 'GET'
  });

  /**
   * report definition related APIs
   */
  opensearchReports.createReportDefinition = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}`
    },
    method: 'POST',
    needBody: true
  });
  opensearchReports.updateReportDefinitionById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });
  opensearchReports.getReportDefinitionById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  opensearchReports.getReportDefinitions = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.LIST_REPORT_DEFINITIONS}`,
      params: {
        fromIndex: {
          type: 'number'
        },
        maxItems: {
          type: 'number'
        }
      }
    },
    method: 'GET'
  });
  opensearchReports.deleteReportDefinitionById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_REPORTS_API.REPORT_DEFINITION}/<%=reportDefinitionId%>`,
      req: {
        reportDefinitionId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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