/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.tracing;

import com.microsoft.windowsazure.tracing.CloudTracingInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public abstract class CloudTracing {
    private static List<CloudTracingInterceptor> interceptors;
    private static boolean isEnabled;
    private static long nextInvocationId;

    private CloudTracing() {
    }

    public static List<CloudTracingInterceptor> getInterceptors() {
        return interceptors;
    }

    public static boolean getIsEnabled() {
        return isEnabled;
    }

    public static void setIsEnabled(boolean enabled) {
        isEnabled = enabled;
    }

    public static void addTracingInterceptor(CloudTracingInterceptor cloudTracingInterceptor) {
        if (cloudTracingInterceptor == null) {
            throw new NullPointerException();
        }
        interceptors.add(cloudTracingInterceptor);
    }

    public static boolean removeTracingInterceptor(CloudTracingInterceptor cloudTracingInterceptor) {
        if (cloudTracingInterceptor == null) {
            throw new NullPointerException();
        }
        return interceptors.remove(cloudTracingInterceptor);
    }

    public static long getNextInvocationId() {
        return ++nextInvocationId;
    }

    public static void information(String message, Object ... parameters) {
        if (isEnabled) {
            CloudTracing.information(String.format(message, parameters));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configuration(String source, String name, String value) {
        if (isEnabled) {
            List<CloudTracingInterceptor> list = interceptors;
            synchronized (list) {
                for (CloudTracingInterceptor writer : interceptors) {
                    writer.configuration(source, name, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void information(String message) {
        if (isEnabled) {
            List<CloudTracingInterceptor> list = interceptors;
            synchronized (list) {
                for (CloudTracingInterceptor writer : interceptors) {
                    writer.information(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enter(String invocationId, Object instance, String method, HashMap<String, Object> parameters) {
        if (isEnabled) {
            List<CloudTracingInterceptor> list = interceptors;
            synchronized (list) {
                for (CloudTracingInterceptor writer : interceptors) {
                    writer.enter(invocationId, instance, method, parameters);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendRequest(String invocationId, HttpRequest request) {
        if (isEnabled) {
            List<CloudTracingInterceptor> list = interceptors;
            synchronized (list) {
                for (CloudTracingInterceptor writer : interceptors) {
                    writer.sendRequest(invocationId, request);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveResponse(String invocationId, HttpResponse response) {
        if (isEnabled) {
            List<CloudTracingInterceptor> list = interceptors;
            synchronized (list) {
                for (CloudTracingInterceptor writer : interceptors) {
                    writer.receiveResponse(invocationId, response);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String invocationId, Exception ex) {
        if (isEnabled) {
            List<CloudTracingInterceptor> list = interceptors;
            synchronized (list) {
                for (CloudTracingInterceptor writer : interceptors) {
                    writer.error(invocationId, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(String invocationId, Object result) {
        if (isEnabled) {
            List<CloudTracingInterceptor> list = interceptors;
            synchronized (list) {
                for (CloudTracingInterceptor writer : interceptors) {
                    writer.exit(invocationId, result);
                }
            }
        }
    }

    static {
        isEnabled = true;
        interceptors = Collections.synchronizedList(new ArrayList());
        nextInvocationId = 0L;
    }
}

