/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.async;

import java.util.Iterator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkProtectedApi
public class IterablePublisher<T>
implements Publisher<T> {
    private final Iterable<T> iterable;

    public IterablePublisher(Iterable<T> iterable) {
        this.iterable = Validate.paramNotNull(iterable, "iterable");
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Iterator<T> iterator = this.iterable.iterator();
        SimplePublisher<? super T> publisher = new SimplePublisher<T>();
        this.sendEvent(iterator, publisher);
        publisher.subscribe(subscriber);
    }

    private void sendEvent(Iterator<T> iterator, SimplePublisher<T> publisher) {
        try {
            if (!iterator.hasNext()) {
                publisher.complete();
                return;
            }
            T next = iterator.next();
            if (next == null) {
                publisher.error(new IllegalArgumentException("Iterable returned null"));
                return;
            }
            publisher.send(next).whenComplete((v, t) -> {
                if (t != null) {
                    publisher.error((Throwable)t);
                } else {
                    this.sendEvent(iterator, publisher);
                }
            });
        }
        catch (Throwable e) {
            publisher.error(e);
        }
    }
}

