/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpnConnection;
import software.amazon.awssdk.services.ec2.model.VpnConnectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpnConnectionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
    private static final SdkField<List<VpnConnection>> VPN_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpnConnections").getter(DescribeVpnConnectionsResponse.getter(DescribeVpnConnectionsResponse::vpnConnections)).setter(DescribeVpnConnectionsResponse.setter(Builder::vpnConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionSet").unmarshallLocationName("vpnConnectionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpnConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpnConnectionsResponse.memberNameToFieldInitializer();
    private final List<VpnConnection> vpnConnections;

    private DescribeVpnConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConnections = builder.vpnConnections;
    }

    public final boolean hasVpnConnections() {
        return this.vpnConnections != null && !(this.vpnConnections instanceof SdkAutoConstructList);
    }

    public final List<VpnConnection> vpnConnections() {
        return this.vpnConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpnConnections() ? this.vpnConnections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsResponse)) {
            return false;
        }
        DescribeVpnConnectionsResponse other = (DescribeVpnConnectionsResponse)((Object)obj);
        return this.hasVpnConnections() == other.hasVpnConnections() && Objects.equals(this.vpnConnections(), other.vpnConnections());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpnConnectionsResponse").add("VpnConnections", this.hasVpnConnections() ? this.vpnConnections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnections": {
                return Optional.ofNullable(clazz.cast(this.vpnConnections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<VpnConnection>>> map = new HashMap<String, SdkField<List<VpnConnection>>>();
        map.put("VpnConnectionSet", VPN_CONNECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpnConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeVpnConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpnConnection> vpnConnections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsResponse model) {
            super(model);
            this.vpnConnections(model.vpnConnections);
        }

        public final List<VpnConnection.Builder> getVpnConnections() {
            List<VpnConnection.Builder> result = VpnConnectionListCopier.copyToBuilder(this.vpnConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpnConnections(Collection<VpnConnection.BuilderImpl> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copyFromBuilder(vpnConnections);
        }

        @Override
        public final Builder vpnConnections(Collection<VpnConnection> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copy(vpnConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnections(VpnConnection ... vpnConnections) {
            this.vpnConnections(Arrays.asList(vpnConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnections(Consumer<VpnConnection.Builder> ... vpnConnections) {
            this.vpnConnections(Stream.of(vpnConnections).map(c -> (VpnConnection)((VpnConnection.Builder)VpnConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpnConnectionsResponse build() {
            return new DescribeVpnConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
        public Builder vpnConnections(Collection<VpnConnection> var1);

        public Builder vpnConnections(VpnConnection ... var1);

        public Builder vpnConnections(Consumer<VpnConnection.Builder> ... var1);
    }
}

