/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ImageState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageMetadata> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ImageMetadata.getter(ImageMetadata::imageId)).setter(ImageMetadata.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ImageMetadata.getter(ImageMetadata::name)).setter(ImageMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(ImageMetadata.getter(ImageMetadata::ownerId)).setter(ImageMetadata.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerId").unmarshallLocationName("imageOwnerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ImageMetadata.getter(ImageMetadata::stateAsString)).setter(ImageMetadata.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageState").unmarshallLocationName("imageState").build()}).build();
    private static final SdkField<String> IMAGE_OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageOwnerAlias").getter(ImageMetadata.getter(ImageMetadata::imageOwnerAlias)).setter(ImageMetadata.setter(Builder::imageOwnerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerAlias").unmarshallLocationName("imageOwnerAlias").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(ImageMetadata.getter(ImageMetadata::creationDate)).setter(ImageMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").unmarshallLocationName("creationDate").build()}).build();
    private static final SdkField<String> DEPRECATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeprecationTime").getter(ImageMetadata.getter(ImageMetadata::deprecationTime)).setter(ImageMetadata.setter(Builder::deprecationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecationTime").unmarshallLocationName("deprecationTime").build()}).build();
    private static final SdkField<Boolean> IMAGE_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ImageAllowed").getter(ImageMetadata.getter(ImageMetadata::imageAllowed)).setter(ImageMetadata.setter(Builder::imageAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageAllowed").unmarshallLocationName("imageAllowed").build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPublic").getter(ImageMetadata.getter(ImageMetadata::isPublic)).setter(ImageMetadata.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPublic").unmarshallLocationName("isPublic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, NAME_FIELD, OWNER_ID_FIELD, STATE_FIELD, IMAGE_OWNER_ALIAS_FIELD, CREATION_DATE_FIELD, DEPRECATION_TIME_FIELD, IMAGE_ALLOWED_FIELD, IS_PUBLIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String imageId;
    private final String name;
    private final String ownerId;
    private final String state;
    private final String imageOwnerAlias;
    private final String creationDate;
    private final String deprecationTime;
    private final Boolean imageAllowed;
    private final Boolean isPublic;

    private ImageMetadata(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.creationDate = builder.creationDate;
        this.deprecationTime = builder.deprecationTime;
        this.imageAllowed = builder.imageAllowed;
        this.isPublic = builder.isPublic;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final ImageState state() {
        return ImageState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String imageOwnerAlias() {
        return this.imageOwnerAlias;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String deprecationTime() {
        return this.deprecationTime;
    }

    public final Boolean imageAllowed() {
        return this.imageAllowed;
    }

    public final Boolean isPublic() {
        return this.isPublic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageOwnerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageMetadata)) {
            return false;
        }
        ImageMetadata other = (ImageMetadata)obj;
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.imageOwnerAlias(), other.imageOwnerAlias()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.deprecationTime(), other.deprecationTime()) && Objects.equals(this.imageAllowed(), other.imageAllowed()) && Objects.equals(this.isPublic(), other.isPublic());
    }

    public final String toString() {
        return ToString.builder((String)"ImageMetadata").add("ImageId", (Object)this.imageId()).add("Name", (Object)this.name()).add("OwnerId", (Object)this.ownerId()).add("State", (Object)this.stateAsString()).add("ImageOwnerAlias", (Object)this.imageOwnerAlias()).add("CreationDate", (Object)this.creationDate()).add("DeprecationTime", (Object)this.deprecationTime()).add("ImageAllowed", (Object)this.imageAllowed()).add("IsPublic", (Object)this.isPublic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ImageOwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.imageOwnerAlias()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "DeprecationTime": {
                return Optional.ofNullable(clazz.cast(this.deprecationTime()));
            }
            case "ImageAllowed": {
                return Optional.ofNullable(clazz.cast(this.imageAllowed()));
            }
            case "IsPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ImageOwnerId", OWNER_ID_FIELD);
        map.put("ImageState", STATE_FIELD);
        map.put("ImageOwnerAlias", IMAGE_OWNER_ALIAS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("DeprecationTime", DEPRECATION_TIME_FIELD);
        map.put("ImageAllowed", IMAGE_ALLOWED_FIELD);
        map.put("IsPublic", IS_PUBLIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageMetadata, T> g) {
        return obj -> g.apply((ImageMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageId;
        private String name;
        private String ownerId;
        private String state;
        private String imageOwnerAlias;
        private String creationDate;
        private String deprecationTime;
        private Boolean imageAllowed;
        private Boolean isPublic;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageMetadata model) {
            this.imageId(model.imageId);
            this.name(model.name);
            this.ownerId(model.ownerId);
            this.state(model.state);
            this.imageOwnerAlias(model.imageOwnerAlias);
            this.creationDate(model.creationDate);
            this.deprecationTime(model.deprecationTime);
            this.imageAllowed(model.imageAllowed);
            this.isPublic(model.isPublic);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getImageOwnerAlias() {
            return this.imageOwnerAlias;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDeprecationTime() {
            return this.deprecationTime;
        }

        public final void setDeprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
        }

        @Override
        public final Builder deprecationTime(String deprecationTime) {
            this.deprecationTime = deprecationTime;
            return this;
        }

        public final Boolean getImageAllowed() {
            return this.imageAllowed;
        }

        public final void setImageAllowed(Boolean imageAllowed) {
            this.imageAllowed = imageAllowed;
        }

        @Override
        public final Builder imageAllowed(Boolean imageAllowed) {
            this.imageAllowed = imageAllowed;
            return this;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public ImageMetadata build() {
            return new ImageMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageMetadata> {
        public Builder imageId(String var1);

        public Builder name(String var1);

        public Builder ownerId(String var1);

        public Builder state(String var1);

        public Builder state(ImageState var1);

        public Builder imageOwnerAlias(String var1);

        public Builder creationDate(String var1);

        public Builder deprecationTime(String var1);

        public Builder imageAllowed(Boolean var1);

        public Builder isPublic(Boolean var1);
    }
}

