/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AddressAttribute;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse;

public class DescribeAddressesAttributePublisher
implements SdkPublisher<DescribeAddressesAttributeResponse> {
    private final Ec2AsyncClient client;
    private final DescribeAddressesAttributeRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAddressesAttributePublisher(Ec2AsyncClient client, DescribeAddressesAttributeRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAddressesAttributePublisher(Ec2AsyncClient client, DescribeAddressesAttributeRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAddressesAttributeResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAddressesAttributeResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AddressAttribute> addresses() {
        Function<DescribeAddressesAttributeResponse, Iterator> getIterator = response -> {
            if (response != null && response.addresses() != null) {
                return response.addresses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAddressesAttributeResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAddressesAttributeResponseFetcher
    implements AsyncPageFetcher<DescribeAddressesAttributeResponse> {
        private DescribeAddressesAttributeResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddressesAttributeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAddressesAttributeResponse> nextPage(DescribeAddressesAttributeResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddressesAttributePublisher.this.client.describeAddressesAttribute(DescribeAddressesAttributePublisher.this.firstRequest);
            }
            return DescribeAddressesAttributePublisher.this.client.describeAddressesAttribute((DescribeAddressesAttributeRequest)((Object)DescribeAddressesAttributePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

