/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOffering;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsResponse;

public class DescribeCapacityBlockExtensionOfferingsIterable
implements SdkIterable<DescribeCapacityBlockExtensionOfferingsResponse> {
    private final Ec2Client client;
    private final DescribeCapacityBlockExtensionOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityBlockExtensionOfferingsIterable(Ec2Client client, DescribeCapacityBlockExtensionOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityBlockExtensionOfferingsResponseFetcher();
    }

    public Iterator<DescribeCapacityBlockExtensionOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings() {
        Function<DescribeCapacityBlockExtensionOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockExtensionOfferings() != null) {
                return response.capacityBlockExtensionOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityBlockExtensionOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeCapacityBlockExtensionOfferingsResponse> {
        private DescribeCapacityBlockExtensionOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockExtensionOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityBlockExtensionOfferingsResponse nextPage(DescribeCapacityBlockExtensionOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockExtensionOfferingsIterable.this.client.describeCapacityBlockExtensionOfferings(DescribeCapacityBlockExtensionOfferingsIterable.this.firstRequest);
            }
            return DescribeCapacityBlockExtensionOfferingsIterable.this.client.describeCapacityBlockExtensionOfferings((DescribeCapacityBlockExtensionOfferingsRequest)((Object)DescribeCapacityBlockExtensionOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

