/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AuthorizationRule;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse;

public class DescribeClientVpnAuthorizationRulesIterable
implements SdkIterable<DescribeClientVpnAuthorizationRulesResponse> {
    private final Ec2Client client;
    private final DescribeClientVpnAuthorizationRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClientVpnAuthorizationRulesIterable(Ec2Client client, DescribeClientVpnAuthorizationRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeClientVpnAuthorizationRulesResponseFetcher();
    }

    public Iterator<DescribeClientVpnAuthorizationRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuthorizationRule> authorizationRules() {
        Function<DescribeClientVpnAuthorizationRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.authorizationRules() != null) {
                return response.authorizationRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClientVpnAuthorizationRulesResponseFetcher
    implements SyncPageFetcher<DescribeClientVpnAuthorizationRulesResponse> {
        private DescribeClientVpnAuthorizationRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnAuthorizationRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClientVpnAuthorizationRulesResponse nextPage(DescribeClientVpnAuthorizationRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnAuthorizationRulesIterable.this.client.describeClientVpnAuthorizationRules(DescribeClientVpnAuthorizationRulesIterable.this.firstRequest);
            }
            return DescribeClientVpnAuthorizationRulesIterable.this.client.describeClientVpnAuthorizationRules((DescribeClientVpnAuthorizationRulesRequest)((Object)DescribeClientVpnAuthorizationRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

