/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface;

public class DescribeLocalGatewayVirtualInterfacesIterable
implements SdkIterable<DescribeLocalGatewayVirtualInterfacesResponse> {
    private final Ec2Client client;
    private final DescribeLocalGatewayVirtualInterfacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLocalGatewayVirtualInterfacesIterable(Ec2Client client, DescribeLocalGatewayVirtualInterfacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLocalGatewayVirtualInterfacesResponseFetcher();
    }

    public Iterator<DescribeLocalGatewayVirtualInterfacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces() {
        Function<DescribeLocalGatewayVirtualInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.localGatewayVirtualInterfaces() != null) {
                return response.localGatewayVirtualInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLocalGatewayVirtualInterfacesResponseFetcher
    implements SyncPageFetcher<DescribeLocalGatewayVirtualInterfacesResponse> {
        private DescribeLocalGatewayVirtualInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewayVirtualInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLocalGatewayVirtualInterfacesResponse nextPage(DescribeLocalGatewayVirtualInterfacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewayVirtualInterfacesIterable.this.client.describeLocalGatewayVirtualInterfaces(DescribeLocalGatewayVirtualInterfacesIterable.this.firstRequest);
            }
            return DescribeLocalGatewayVirtualInterfacesIterable.this.client.describeLocalGatewayVirtualInterfaces((DescribeLocalGatewayVirtualInterfacesRequest)((Object)DescribeLocalGatewayVirtualInterfacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

