/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermission;

public class DescribeNetworkInterfacePermissionsIterable
implements SdkIterable<DescribeNetworkInterfacePermissionsResponse> {
    private final Ec2Client client;
    private final DescribeNetworkInterfacePermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNetworkInterfacePermissionsIterable(Ec2Client client, DescribeNetworkInterfacePermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNetworkInterfacePermissionsResponseFetcher();
    }

    public Iterator<DescribeNetworkInterfacePermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkInterfacePermission> networkInterfacePermissions() {
        Function<DescribeNetworkInterfacePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInterfacePermissions() != null) {
                return response.networkInterfacePermissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNetworkInterfacePermissionsResponseFetcher
    implements SyncPageFetcher<DescribeNetworkInterfacePermissionsResponse> {
        private DescribeNetworkInterfacePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInterfacePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNetworkInterfacePermissionsResponse nextPage(DescribeNetworkInterfacePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInterfacePermissionsIterable.this.client.describeNetworkInterfacePermissions(DescribeNetworkInterfacePermissionsIterable.this.firstRequest);
            }
            return DescribeNetworkInterfacePermissionsIterable.this.client.describeNetworkInterfacePermissions((DescribeNetworkInterfacePermissionsRequest)((Object)DescribeNetworkInterfacePermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

