/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.xml;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class HyperlinkHandler
extends DefaultHandler {
    private final ContentHandler handler;
    private final String namespace;
    boolean inLink = false;
    StringBuilder linkCache = new StringBuilder();
    String href = null;

    public HyperlinkHandler(ContentHandler handler, String namespace) {
        this.handler = handler;
        this.namespace = namespace;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if ("http://schemas.microsoft.com/office/word/2003/wordml".equals(uri) && "hlink".equals(localName)) {
            this.href = attrs.getValue("http://schemas.microsoft.com/office/word/2003/wordml", "dest");
            if (this.href != null) {
                this.href = this.href.trim();
            }
            this.inLink = true;
        }
    }

    @Override
    public void characters(char[] str, int offset, int len) throws SAXException {
        if (this.inLink) {
            this.linkCache.append(str, offset, len);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.namespace.equals(uri)) {
            return;
        }
        if ("hlink".equals(localName)) {
            AttributesImpl attrs = new AttributesImpl();
            if (this.href != null) {
                attrs.addAttribute("http://www.w3.org/1999/xhtml", "href", "href", "cdata", this.href);
            }
            this.handler.startElement("http://www.w3.org/1999/xhtml", "a", "a", attrs);
            String linkString = this.linkCache.toString();
            if (linkString != null) {
                char[] chars = linkString.trim().toCharArray();
                this.handler.characters(chars, 0, chars.length);
            }
            this.handler.endElement("http://www.w3.org/1999/xhtml", "a", "a");
            this.linkCache.setLength(0);
            this.inLink = false;
            this.href = null;
        }
    }
}

