/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.common.KNNValidationUtil;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;

public class FaissFP16Util {
    static PerDimensionValidator FP16_VALIDATOR = new PerDimensionValidator(){

        @Override
        public void validate(float value) {
            FaissFP16Util.validateFP16VectorValue(value);
        }

        @Override
        public void validateByte(float value) {
            throw new IllegalStateException("DEFAULT_FP16_VALIDATOR should only be used for float vectors");
        }
    };
    static PerDimensionProcessor CLIP_TO_FP16_PROCESSOR = new PerDimensionProcessor(){

        @Override
        public float process(float value) {
            return FaissFP16Util.clipVectorValueToFP16Range(value);
        }

        @Override
        public float processByte(float value) {
            throw new IllegalStateException("CLIP_TO_FP16_PROCESSOR should not be called with byte type");
        }
    };

    public static float clipVectorValueToFP16Range(float value) {
        KNNValidationUtil.validateFloatVectorValue(value);
        if (value < KNNConstants.FP16_MIN_VALUE.floatValue()) {
            return KNNConstants.FP16_MIN_VALUE.floatValue();
        }
        if (value > KNNConstants.FP16_MAX_VALUE.floatValue()) {
            return KNNConstants.FP16_MAX_VALUE.floatValue();
        }
        return value;
    }

    public static void validateFP16VectorValue(float value) {
        KNNValidationUtil.validateFloatVectorValue(value);
        if (value < KNNConstants.FP16_MIN_VALUE.floatValue() || value > KNNConstants.FP16_MAX_VALUE.floatValue()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "encoder name is set as [%s] and type is set as [%s] in index mapping. But, KNN vector values are not within in the FP16 range [%f, %f]", "sq", "fp16", KNNConstants.FP16_MIN_VALUE, KNNConstants.FP16_MAX_VALUE));
        }
    }

    static boolean isFaissSQfp16(MethodComponentContext methodComponentContext) {
        MethodComponentContext encoderContext = FaissFP16Util.extractEncoderMethodComponentContext(methodComponentContext);
        if (encoderContext == null) {
            return false;
        }
        return "sq".equals(encoderContext.getName()) && "fp16".equals(encoderContext.getParameters().getOrDefault("type", "fp16"));
    }

    static boolean isFaissSQClipToFP16RangeEnabled(MethodComponentContext methodComponentContext) {
        MethodComponentContext encoderContext = FaissFP16Util.extractEncoderMethodComponentContext(methodComponentContext);
        if (encoderContext == null) {
            return false;
        }
        return (Boolean)encoderContext.getParameters().getOrDefault("clip", false);
    }

    static MethodComponentContext extractEncoderMethodComponentContext(MethodComponentContext methodComponentContext) {
        if (Objects.isNull(methodComponentContext)) {
            return null;
        }
        if (methodComponentContext.getParameters().isEmpty()) {
            return null;
        }
        Map<String, Object> methodComponentParams = methodComponentContext.getParameters();
        if (!methodComponentParams.containsKey("encoder")) {
            return null;
        }
        if (!(methodComponentParams.get("encoder") instanceof MethodComponentContext)) {
            return null;
        }
        return (MethodComponentContext)methodComponentParams.get("encoder");
    }
}

