/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TopDocs;

public class TopDocsDISI
extends DocIdSetIterator {
    private final int[] sortedDocIds;
    private final float[] scores;
    private int idx = -1;

    public TopDocsDISI(TopDocs topDocs) {
        Arrays.sort(topDocs.scoreDocs, Comparator.comparingInt(a -> a.doc));
        this.sortedDocIds = new int[topDocs.scoreDocs.length];
        this.scores = new float[topDocs.scoreDocs.length];
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            this.sortedDocIds[i] = topDocs.scoreDocs[i].doc;
            this.scores[i] = topDocs.scoreDocs[i].score;
        }
    }

    public int docID() {
        if (this.idx == -1) {
            return this.idx;
        }
        if (this.idx >= this.sortedDocIds.length) {
            return Integer.MAX_VALUE;
        }
        return this.sortedDocIds[this.idx];
    }

    public int nextDoc() throws IOException {
        ++this.idx;
        return this.docID();
    }

    public int advance(int target) throws IOException {
        return this.slowAdvance(target);
    }

    public long cost() {
        return this.sortedDocIds.length;
    }

    public float score() {
        if (this.idx == -1) {
            return this.idx;
        }
        if (this.idx >= this.sortedDocIds.length) {
            return Float.MAX_VALUE;
        }
        return this.scores[this.idx];
    }
}

