/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.vectorvalues;

import java.io.IOException;
import org.opensearch.knn.index.codec.nativeindex.IndexBuildSetup;
import org.opensearch.knn.index.codec.nativeindex.QuantizationIndexUtils;
import org.opensearch.knn.index.codec.nativeindex.model.BuildIndexParams;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesIterator;

public class QuantizedKNNBinaryVectorValues
extends KNNVectorValues<byte[]> {
    private KNNFloatVectorValues knnFloatVectorValues;
    private IndexBuildSetup indexBuildSetup;

    public QuantizedKNNBinaryVectorValues(KNNVectorValues<?> orgKnnVectorValues, BuildIndexParams indexInfo) {
        super(QuantizedKNNBinaryVectorValues.extractIteratorSafeAndSet(orgKnnVectorValues));
        this.knnFloatVectorValues = (KNNFloatVectorValues)orgKnnVectorValues;
        this.indexBuildSetup = QuantizationIndexUtils.prepareIndexBuild(orgKnnVectorValues, indexInfo);
    }

    private static KNNVectorValuesIterator extractIteratorSafeAndSet(KNNVectorValues<?> orgKnnVectorValues) {
        if (!(orgKnnVectorValues instanceof KNNFloatVectorValues)) {
            throw new IllegalArgumentException("Expected " + KNNFloatVectorValues.class.getName() + " but got " + orgKnnVectorValues.getClass().getSimpleName());
        }
        return orgKnnVectorValues.vectorValuesIterator;
    }

    @Override
    public byte[] getVector() throws IOException {
        byte[] quantizedVector = (byte[])QuantizationIndexUtils.processAndReturnVector(this.knnFloatVectorValues, this.indexBuildSetup);
        this.dimension = quantizedVector.length * 8;
        this.bytesPerVector = quantizedVector.length;
        return quantizedVector;
    }

    @Override
    public byte[] conditionalCloneVector() throws IOException {
        return this.getVector();
    }
}

