/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import lombok.NonNull;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexSettings;
import org.opensearch.neuralsearch.processor.CompoundTopDocs;
import org.opensearch.search.SearchHit;

public class ProcessorUtils {
    public static boolean validateRerankCriteria(SearchHit[] searchHits, SearchHitValidator validator, ActionListener<List<Float>> listener) {
        for (SearchHit hit : searchHits) {
            try {
                validator.validate(hit);
            }
            catch (IllegalArgumentException e) {
                listener.onFailure((Exception)e);
                return false;
            }
        }
        return true;
    }

    public static float getScoreFromSourceMap(Map<String, Object> sourceAsMap, String targetField) {
        Object val = ProcessorUtils.getValueFromSource(sourceAsMap, targetField).get();
        if (val instanceof String) {
            return Float.parseFloat((String)val);
        }
        return ((Number)val).floatValue();
    }

    public static void removeTargetFieldFromSource(Map<String, Object> sourceAsMap, String targetField) {
        Stack<Tuple> parentMapChildrenKeyTupleStack = new Stack<Tuple>();
        String[] keys = targetField.split("\\.");
        Map<String, Object> currentMap = sourceAsMap;
        String lastKey = keys[keys.length - 1];
        for (String key : keys) {
            parentMapChildrenKeyTupleStack.add(new Tuple(currentMap, (Object)key));
            if (key.equals(lastKey)) break;
            currentMap = ProcessorUtils.unsafeCastToObjectMap(currentMap.get(key));
        }
        Tuple currentParentMapWithChild = (Tuple)parentMapChildrenKeyTupleStack.pop();
        Map parentMap = (Map)currentParentMapWithChild.v1();
        String key = (String)currentParentMapWithChild.v2();
        parentMap.remove(key);
        while (!parentMapChildrenKeyTupleStack.isEmpty()) {
            currentParentMapWithChild = (Tuple)parentMapChildrenKeyTupleStack.pop();
            parentMap = (Map)currentParentMapWithChild.v1();
            Map<String, Object> innerMap = ProcessorUtils.unsafeCastToObjectMap(parentMap.get(key = (String)currentParentMapWithChild.v2()));
            if (innerMap == null || !innerMap.isEmpty()) continue;
            parentMap.remove(key);
        }
    }

    public static Optional<Object> getValueFromSource(Map<String, Object> sourceAsMap, String targetField) {
        String[] keys = targetField.split("\\.");
        List<Object> current = sourceAsMap;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (current instanceof Map) {
                current = ProcessorUtils.unsafeCastToObjectMap(current).get(key);
                if (i != keys.length - 1 || !(current instanceof List) || ProcessorUtils.unsafeCastToObjectList(current).isEmpty() || !(ProcessorUtils.unsafeCastToObjectList(current).getFirst() instanceof String)) continue;
                return Optional.of(List.of(current));
            }
            if (current instanceof List) {
                List<Object> results = ProcessorUtils.parseList(ProcessorUtils.unsafeCastToObjectList(current), key);
                if (results.isEmpty()) {
                    return Optional.empty();
                }
                current = results;
                continue;
            }
            return Optional.empty();
        }
        return Optional.ofNullable(current);
    }

    public static Object getValueFromSourceByFullPath(Map<String, Object> sourceAsMap, String fullPath) {
        if (sourceAsMap == null || fullPath == null || fullPath.isEmpty()) {
            return null;
        }
        String[] parts = fullPath.split("\\.");
        Object current = sourceAsMap;
        for (String part : parts) {
            if (current instanceof Map) {
                Map<String, Object> map = current;
                current = map.get(part);
            } else if (current instanceof List) {
                List list = (List)current;
                try {
                    int index = Integer.parseInt(part);
                    if (index < 0 || index >= list.size()) {
                        return null;
                    }
                    current = list.get(index);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else {
                return null;
            }
            if (current != null) continue;
            return null;
        }
        return current;
    }

    private static List<Object> parseList(List<Object> list, String key) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : list) {
            Object value;
            if (!(item instanceof Map) || (value = ProcessorUtils.unsafeCastToObjectMap(item).get(key)) == null) continue;
            result.add(value);
        }
        return result;
    }

    public static void setValueToSource(Map<String, Object> sourceAsMap, String targetKey, Object targetValue) {
        ProcessorUtils.setValueToSource(sourceAsMap, targetKey, targetValue, -1);
    }

    public static void setValueToSource(Map<String, Object> sourceAsMap, String targetKey, Object targetValue, int index) {
        if (Objects.isNull(sourceAsMap) || Objects.isNull(targetKey)) {
            return;
        }
        String[] keys = targetKey.split("\\.");
        Map<String, Object> current = sourceAsMap;
        for (int i = 0; i < keys.length - 1; ++i) {
            Object next = current.computeIfAbsent(keys[i], k -> new HashMap());
            if (next instanceof ArrayList) {
                ArrayList list = (ArrayList)next;
                if (index < 0 || index >= list.size()) {
                    return;
                }
                if (!(list.get(index) instanceof Map)) continue;
                current = ProcessorUtils.unsafeCastToObjectMap(list.get(index));
                continue;
            }
            if (next instanceof Map) {
                current = ProcessorUtils.unsafeCastToObjectMap(next);
                continue;
            }
            throw new IllegalStateException("Unexpected data structure at " + keys[i]);
        }
        String lastKey = keys[keys.length - 1];
        current.put(lastKey, targetValue);
    }

    public static boolean mappingExistsInSource(Map<String, Object> sourceAsMap, String pathToValue) {
        return ProcessorUtils.getValueFromSource(sourceAsMap, pathToValue).isPresent();
    }

    public static boolean isNumeric(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                Double.parseDouble(string);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static int getNumOfSubqueries(List<CompoundTopDocs> queryTopDocs) {
        return queryTopDocs.stream().filter(Objects::nonNull).filter(topDocs -> !topDocs.getTopDocs().isEmpty()).findAny().get().getTopDocs().size();
    }

    public static Map<String, Object> unsafeCastToObjectMap(Object obj) {
        return (Map)obj;
    }

    public static List<Object> unsafeCastToObjectList(Object obj) {
        return (List)obj;
    }

    public static int getMaxTokenCount(@NonNull Map<String, Object> sourceAndMetadataMap, @NonNull Settings settings, @NonNull ClusterService clusterService) {
        Objects.requireNonNull(sourceAndMetadataMap, "sourceAndMetadataMap is marked non-null but is null");
        Objects.requireNonNull(settings, "settings is marked non-null but is null");
        Objects.requireNonNull(clusterService, "clusterService is marked non-null but is null");
        int defaultMaxTokenCount = (Integer)IndexSettings.MAX_TOKEN_COUNT_SETTING.get(settings);
        String indexName = sourceAndMetadataMap.get("_index").toString();
        IndexMetadata indexMetadata = clusterService.state().metadata().index(indexName);
        if (Objects.isNull(indexMetadata)) {
            return defaultMaxTokenCount;
        }
        return (Integer)IndexSettings.MAX_TOKEN_COUNT_SETTING.get(indexMetadata.getSettings());
    }

    @FunctionalInterface
    public static interface SearchHitValidator {
        public void validate(SearchHit var1) throws IllegalArgumentException;
    }
}

