/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.BaseModelConfig;

public class TextEmbeddingModelConfig
extends BaseModelConfig {
    public static final String PARSE_FIELD_NAME = FunctionName.TEXT_EMBEDDING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(TextEmbeddingModelConfig.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> TextEmbeddingModelConfig.parse(it));

    public TextEmbeddingModelConfig(String modelType, Integer embeddingDimension, BaseModelConfig.FrameworkType frameworkType, String allConfig, Map<String, Object> additionalConfig, BaseModelConfig.PoolingMode poolingMode, boolean normalizeResult, Integer modelMaxLength) {
        this(modelType, embeddingDimension, frameworkType, allConfig, additionalConfig, poolingMode, normalizeResult, modelMaxLength, null, null);
    }

    public TextEmbeddingModelConfig(String modelType, Integer embeddingDimension, BaseModelConfig.FrameworkType frameworkType, String allConfig, Map<String, Object> additionalConfig, BaseModelConfig.PoolingMode poolingMode, boolean normalizeResult, Integer modelMaxLength, String queryPrefix, String passagePrefix) {
        super(modelType, allConfig, additionalConfig, embeddingDimension, frameworkType, poolingMode, normalizeResult, modelMaxLength, queryPrefix, passagePrefix);
        if (embeddingDimension == null) {
            throw new IllegalArgumentException("embedding dimension is null");
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException("framework type is null");
        }
        this.validateNoDuplicateKeys(allConfig, additionalConfig);
    }

    public static TextEmbeddingModelConfig parse(XContentParser parser) throws IOException {
        String modelType = null;
        Integer embeddingDimension = null;
        BaseModelConfig.FrameworkType frameworkType = null;
        String allConfig = null;
        Map additionalConfig = null;
        BaseModelConfig.PoolingMode poolingMode = null;
        boolean normalizeResult = false;
        Integer modelMaxLength = null;
        String queryPrefix = null;
        String passagePrefix = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_type": {
                    modelType = parser.text();
                    continue block24;
                }
                case "embedding_dimension": {
                    embeddingDimension = parser.intValue();
                    continue block24;
                }
                case "framework_type": {
                    frameworkType = BaseModelConfig.FrameworkType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block24;
                }
                case "all_config": {
                    allConfig = parser.text();
                    continue block24;
                }
                case "additional_config": {
                    additionalConfig = parser.map();
                    continue block24;
                }
                case "pooling_mode": {
                    poolingMode = BaseModelConfig.PoolingMode.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block24;
                }
                case "normalize_result": {
                    normalizeResult = parser.booleanValue();
                    continue block24;
                }
                case "model_max_length": {
                    modelMaxLength = parser.intValue();
                    continue block24;
                }
                case "query_prefix": {
                    queryPrefix = parser.text();
                    continue block24;
                }
                case "passage_prefix": {
                    passagePrefix = parser.text();
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return new TextEmbeddingModelConfig(modelType, embeddingDimension, frameworkType, allConfig, additionalConfig, poolingMode, normalizeResult, modelMaxLength, queryPrefix, passagePrefix);
    }

    @Override
    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public TextEmbeddingModelConfig(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelType != null) {
            builder.field("model_type", this.modelType);
        }
        if (this.embeddingDimension != null) {
            builder.field("embedding_dimension", this.embeddingDimension);
        }
        if (this.frameworkType != null) {
            builder.field("framework_type", (Object)this.frameworkType);
        }
        if (this.allConfig != null) {
            builder.field("all_config", this.allConfig);
        }
        if (this.additionalConfig != null) {
            builder.field("additional_config", this.additionalConfig);
        }
        if (this.modelMaxLength != null) {
            builder.field("model_max_length", this.modelMaxLength);
        }
        if (this.poolingMode != null) {
            builder.field("pooling_mode", (Object)this.poolingMode);
        }
        if (this.normalizeResult) {
            builder.field("normalize_result", this.normalizeResult);
        }
        if (this.queryPrefix != null) {
            builder.field("query_prefix", this.queryPrefix);
        }
        if (this.passagePrefix != null) {
            builder.field("passage_prefix", this.passagePrefix);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static TextEmbeddingModelConfigBuilder builder() {
        return new TextEmbeddingModelConfigBuilder();
    }

    @Generated
    public TextEmbeddingModelConfigBuilder toBuilder() {
        return new TextEmbeddingModelConfigBuilder().modelType(this.modelType).embeddingDimension(this.embeddingDimension).frameworkType(this.frameworkType).allConfig(this.allConfig).additionalConfig(this.additionalConfig).poolingMode(this.poolingMode).normalizeResult(this.normalizeResult).modelMaxLength(this.modelMaxLength).queryPrefix(this.queryPrefix).passagePrefix(this.passagePrefix);
    }

    @Generated
    public static class TextEmbeddingModelConfigBuilder {
        @Generated
        private String modelType;
        @Generated
        private Integer embeddingDimension;
        @Generated
        private BaseModelConfig.FrameworkType frameworkType;
        @Generated
        private String allConfig;
        @Generated
        private Map<String, Object> additionalConfig;
        @Generated
        private BaseModelConfig.PoolingMode poolingMode;
        @Generated
        private boolean normalizeResult;
        @Generated
        private Integer modelMaxLength;
        @Generated
        private String queryPrefix;
        @Generated
        private String passagePrefix;

        @Generated
        TextEmbeddingModelConfigBuilder() {
        }

        @Generated
        public TextEmbeddingModelConfigBuilder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder embeddingDimension(Integer embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder frameworkType(BaseModelConfig.FrameworkType frameworkType) {
            this.frameworkType = frameworkType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder allConfig(String allConfig) {
            this.allConfig = allConfig;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder additionalConfig(Map<String, Object> additionalConfig) {
            this.additionalConfig = additionalConfig;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder poolingMode(BaseModelConfig.PoolingMode poolingMode) {
            this.poolingMode = poolingMode;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder normalizeResult(boolean normalizeResult) {
            this.normalizeResult = normalizeResult;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder modelMaxLength(Integer modelMaxLength) {
            this.modelMaxLength = modelMaxLength;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder queryPrefix(String queryPrefix) {
            this.queryPrefix = queryPrefix;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder passagePrefix(String passagePrefix) {
            this.passagePrefix = passagePrefix;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfig build() {
            return new TextEmbeddingModelConfig(this.modelType, this.embeddingDimension, this.frameworkType, this.allConfig, this.additionalConfig, this.poolingMode, this.normalizeResult, this.modelMaxLength, this.queryPrefix, this.passagePrefix);
        }

        @Generated
        public String toString() {
            return "TextEmbeddingModelConfig.TextEmbeddingModelConfigBuilder(modelType=" + this.modelType + ", embeddingDimension=" + this.embeddingDimension + ", frameworkType=" + String.valueOf((Object)this.frameworkType) + ", allConfig=" + this.allConfig + ", additionalConfig=" + String.valueOf(this.additionalConfig) + ", poolingMode=" + String.valueOf((Object)this.poolingMode) + ", normalizeResult=" + this.normalizeResult + ", modelMaxLength=" + this.modelMaxLength + ", queryPrefix=" + this.queryPrefix + ", passagePrefix=" + this.passagePrefix + ")";
        }
    }
}

