/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.controller.MLRateLimiter;
import org.opensearch.ml.common.model.BaseModelConfig;
import org.opensearch.ml.common.model.Guardrails;
import org.opensearch.ml.common.model.MLDeploySetting;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.utils.StringUtils;

public class MLUpdateModelInput
implements ToXContentObject,
Writeable {
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String MODEL_VERSION_FIELD = "model_version";
    public static final String MODEL_NAME_FIELD = "name";
    public static final String MODEL_GROUP_ID_FIELD = "model_group_id";
    public static final String IS_ENABLED_FIELD = "is_enabled";
    public static final String RATE_LIMITER_FIELD = "rate_limiter";
    public static final String MODEL_CONFIG_FIELD = "model_config";
    public static final String DEPLOY_SETTING_FIELD = "deploy_setting";
    public static final String UPDATED_CONNECTOR_FIELD = "updated_connector";
    public static final String CONNECTOR_ID_FIELD = "connector_id";
    public static final String CONNECTOR_FIELD = "connector";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String GUARDRAILS_FIELD = "guardrails";
    private String modelId;
    private String description;
    private String version;
    private String name;
    private String modelGroupId;
    private Boolean isEnabled;
    private MLRateLimiter rateLimiter;
    private MLModelConfig modelConfig;
    private MLDeploySetting deploySetting;
    private Connector updatedConnector;
    private String connectorId;
    private MLCreateConnectorInput connector;
    private Instant lastUpdateTime;
    private Guardrails guardrails;
    private String tenantId;
    private Map<String, String> modelInterface;

    public MLUpdateModelInput(String modelId, String description, String version, String name, String modelGroupId, Boolean isEnabled, MLRateLimiter rateLimiter, MLModelConfig modelConfig, MLDeploySetting deploySetting, Connector updatedConnector, String connectorId, MLCreateConnectorInput connector, Instant lastUpdateTime, Guardrails guardrails, Map<String, String> modelInterface, String tenantId) {
        this.modelId = modelId;
        this.description = description;
        this.version = version;
        this.name = name;
        this.modelGroupId = modelGroupId;
        this.isEnabled = isEnabled;
        this.rateLimiter = rateLimiter;
        this.modelConfig = modelConfig;
        this.deploySetting = deploySetting;
        this.updatedConnector = updatedConnector;
        this.connectorId = connectorId;
        this.connector = connector;
        this.lastUpdateTime = lastUpdateTime;
        this.guardrails = guardrails;
        this.modelInterface = modelInterface;
        this.tenantId = tenantId;
    }

    public MLUpdateModelInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.modelId = in.readString();
        this.description = in.readOptionalString();
        this.version = in.readOptionalString();
        this.name = in.readOptionalString();
        this.modelGroupId = in.readOptionalString();
        this.isEnabled = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.rateLimiter = new MLRateLimiter(in);
        }
        if (in.readBoolean()) {
            this.modelConfig = new BaseModelConfig(in);
        }
        if (in.readBoolean()) {
            this.updatedConnector = Connector.fromStream(in);
        }
        this.connectorId = in.readOptionalString();
        if (in.readBoolean()) {
            this.connector = new MLCreateConnectorInput(in);
        }
        this.lastUpdateTime = in.readOptionalInstant();
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (in.readBoolean()) {
                this.guardrails = new Guardrails(in);
            }
            if (in.readBoolean()) {
                this.deploySetting = new MLDeploySetting(in);
            }
        }
        if (streamInputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE) && in.readBoolean()) {
            this.modelInterface = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID_FIELD, this.modelId);
        if (this.name != null) {
            builder.field(MODEL_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.version != null) {
            builder.field(MODEL_VERSION_FIELD, this.version);
        }
        if (this.modelGroupId != null) {
            builder.field(MODEL_GROUP_ID_FIELD, this.modelGroupId);
        }
        if (this.isEnabled != null) {
            builder.field(IS_ENABLED_FIELD, this.isEnabled);
        }
        if (this.rateLimiter != null) {
            builder.field(RATE_LIMITER_FIELD, (ToXContent)this.rateLimiter);
        }
        if (this.modelConfig != null) {
            builder.field(MODEL_CONFIG_FIELD, (ToXContent)this.modelConfig);
        }
        if (this.deploySetting != null) {
            builder.field(DEPLOY_SETTING_FIELD, (ToXContent)this.deploySetting);
        }
        if (this.updatedConnector != null) {
            builder.field(CONNECTOR_FIELD, (ToXContent)this.updatedConnector);
        }
        if (this.connectorId != null) {
            builder.field(CONNECTOR_ID_FIELD, this.connectorId);
        }
        if (this.lastUpdateTime != null) {
            builder.field(LAST_UPDATED_TIME_FIELD, this.lastUpdateTime.toEpochMilli());
        }
        if (this.guardrails != null) {
            builder.field(GUARDRAILS_FIELD, (ToXContent)this.guardrails);
        }
        if (this.modelInterface != null) {
            builder.field("interface", this.modelInterface);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeString(this.modelId);
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.version);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.modelGroupId);
        out.writeOptionalBoolean(this.isEnabled);
        if (this.rateLimiter != null) {
            out.writeBoolean(true);
            this.rateLimiter.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelConfig != null) {
            out.writeBoolean(true);
            this.modelConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.updatedConnector != null) {
            out.writeBoolean(true);
            this.updatedConnector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.connectorId);
        if (this.connector != null) {
            out.writeBoolean(true);
            this.connector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.lastUpdateTime);
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_GUARDRAILS_AND_AUTO_DEPLOY)) {
            if (this.guardrails != null) {
                out.writeBoolean(true);
                this.guardrails.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.deploySetting != null) {
                out.writeBoolean(true);
                this.deploySetting.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter(MLRegisterModelInput.MINIMAL_SUPPORTED_VERSION_FOR_INTERFACE)) {
            if (this.modelInterface != null) {
                out.writeBoolean(true);
                out.writeMap(this.modelInterface, StreamOutput::writeString, StreamOutput::writeString);
            } else {
                out.writeBoolean(false);
            }
        }
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    public static MLUpdateModelInput parse(XContentParser parser) throws IOException {
        String modelId = null;
        String description = null;
        String version = null;
        String name = null;
        String modelGroupId = null;
        Boolean isEnabled = null;
        MLRateLimiter rateLimiter = null;
        BaseModelConfig modelConfig = null;
        MLDeploySetting deploySetting = null;
        Connector updatedConnector = null;
        String connectorId = null;
        MLCreateConnectorInput connector = null;
        Instant lastUpdateTime = null;
        Guardrails guardrails = null;
        Map<String, String> modelInterface = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block30: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    continue block30;
                }
                case "description": {
                    description = parser.text();
                    continue block30;
                }
                case "name": {
                    name = parser.text();
                    continue block30;
                }
                case "model_group_id": {
                    modelGroupId = parser.text();
                    continue block30;
                }
                case "is_enabled": {
                    isEnabled = parser.booleanValue();
                    continue block30;
                }
                case "rate_limiter": {
                    rateLimiter = MLRateLimiter.parse(parser);
                    continue block30;
                }
                case "model_config": {
                    modelConfig = BaseModelConfig.parse(parser);
                    continue block30;
                }
                case "deploy_setting": {
                    deploySetting = MLDeploySetting.parse(parser);
                    continue block30;
                }
                case "connector_id": {
                    connectorId = parser.text();
                    continue block30;
                }
                case "connector": {
                    connector = MLCreateConnectorInput.parse(parser, true);
                    continue block30;
                }
                case "guardrails": {
                    guardrails = Guardrails.parse(parser);
                    continue block30;
                }
                case "interface": {
                    modelInterface = StringUtils.filteredParameterMap(parser.map(), MLModel.allowedInterfaceFieldKeys);
                    continue block30;
                }
                case "tenant_id": {
                    tenantId = parser.textOrNull();
                    continue block30;
                }
            }
            parser.skipChildren();
        }
        return new MLUpdateModelInput(modelId, description, version, name, modelGroupId, isEnabled, rateLimiter, modelConfig, deploySetting, updatedConnector, connectorId, connector, lastUpdateTime, guardrails, modelInterface, tenantId);
    }

    @Generated
    public static MLUpdateModelInputBuilder builder() {
        return new MLUpdateModelInputBuilder();
    }

    @Generated
    public MLUpdateModelInputBuilder toBuilder() {
        return new MLUpdateModelInputBuilder().modelId(this.modelId).description(this.description).version(this.version).name(this.name).modelGroupId(this.modelGroupId).isEnabled(this.isEnabled).rateLimiter(this.rateLimiter).modelConfig(this.modelConfig).deploySetting(this.deploySetting).updatedConnector(this.updatedConnector).connectorId(this.connectorId).connector(this.connector).lastUpdateTime(this.lastUpdateTime).guardrails(this.guardrails).modelInterface(this.modelInterface).tenantId(this.tenantId);
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModelGroupId() {
        return this.modelGroupId;
    }

    @Generated
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    @Generated
    public MLRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    @Generated
    public MLModelConfig getModelConfig() {
        return this.modelConfig;
    }

    @Generated
    public MLDeploySetting getDeploySetting() {
        return this.deploySetting;
    }

    @Generated
    public Connector getUpdatedConnector() {
        return this.updatedConnector;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public MLCreateConnectorInput getConnector() {
        return this.connector;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public Guardrails getGuardrails() {
        return this.guardrails;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public Map<String, String> getModelInterface() {
        return this.modelInterface;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModelGroupId(String modelGroupId) {
        this.modelGroupId = modelGroupId;
    }

    @Generated
    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Generated
    public void setRateLimiter(MLRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    @Generated
    public void setModelConfig(MLModelConfig modelConfig) {
        this.modelConfig = modelConfig;
    }

    @Generated
    public void setDeploySetting(MLDeploySetting deploySetting) {
        this.deploySetting = deploySetting;
    }

    @Generated
    public void setUpdatedConnector(Connector updatedConnector) {
        this.updatedConnector = updatedConnector;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setConnector(MLCreateConnectorInput connector) {
        this.connector = connector;
    }

    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setGuardrails(Guardrails guardrails) {
        this.guardrails = guardrails;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setModelInterface(Map<String, String> modelInterface) {
        this.modelInterface = modelInterface;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLUpdateModelInput)) {
            return false;
        }
        MLUpdateModelInput other = (MLUpdateModelInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isEnabled = this.getIsEnabled();
        Boolean other$isEnabled = other.getIsEnabled();
        if (this$isEnabled == null ? other$isEnabled != null : !((Object)this$isEnabled).equals(other$isEnabled)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$modelGroupId = this.getModelGroupId();
        String other$modelGroupId = other.getModelGroupId();
        if (this$modelGroupId == null ? other$modelGroupId != null : !this$modelGroupId.equals(other$modelGroupId)) {
            return false;
        }
        MLRateLimiter this$rateLimiter = this.getRateLimiter();
        MLRateLimiter other$rateLimiter = other.getRateLimiter();
        if (this$rateLimiter == null ? other$rateLimiter != null : !this$rateLimiter.equals(other$rateLimiter)) {
            return false;
        }
        MLModelConfig this$modelConfig = this.getModelConfig();
        MLModelConfig other$modelConfig = other.getModelConfig();
        if (this$modelConfig == null ? other$modelConfig != null : !this$modelConfig.equals(other$modelConfig)) {
            return false;
        }
        MLDeploySetting this$deploySetting = this.getDeploySetting();
        MLDeploySetting other$deploySetting = other.getDeploySetting();
        if (this$deploySetting == null ? other$deploySetting != null : !this$deploySetting.equals(other$deploySetting)) {
            return false;
        }
        Connector this$updatedConnector = this.getUpdatedConnector();
        Connector other$updatedConnector = other.getUpdatedConnector();
        if (this$updatedConnector == null ? other$updatedConnector != null : !this$updatedConnector.equals(other$updatedConnector)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        MLCreateConnectorInput this$connector = this.getConnector();
        MLCreateConnectorInput other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !((Object)this$connector).equals(other$connector)) {
            return false;
        }
        Instant this$lastUpdateTime = this.getLastUpdateTime();
        Instant other$lastUpdateTime = other.getLastUpdateTime();
        if (this$lastUpdateTime == null ? other$lastUpdateTime != null : !((Object)this$lastUpdateTime).equals(other$lastUpdateTime)) {
            return false;
        }
        Guardrails this$guardrails = this.getGuardrails();
        Guardrails other$guardrails = other.getGuardrails();
        if (this$guardrails == null ? other$guardrails != null : !((Object)this$guardrails).equals(other$guardrails)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Map<String, String> this$modelInterface = this.getModelInterface();
        Map<String, String> other$modelInterface = other.getModelInterface();
        return !(this$modelInterface == null ? other$modelInterface != null : !((Object)this$modelInterface).equals(other$modelInterface));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLUpdateModelInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isEnabled = this.getIsEnabled();
        result = result * 59 + ($isEnabled == null ? 43 : ((Object)$isEnabled).hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $modelGroupId = this.getModelGroupId();
        result = result * 59 + ($modelGroupId == null ? 43 : $modelGroupId.hashCode());
        MLRateLimiter $rateLimiter = this.getRateLimiter();
        result = result * 59 + ($rateLimiter == null ? 43 : $rateLimiter.hashCode());
        MLModelConfig $modelConfig = this.getModelConfig();
        result = result * 59 + ($modelConfig == null ? 43 : $modelConfig.hashCode());
        MLDeploySetting $deploySetting = this.getDeploySetting();
        result = result * 59 + ($deploySetting == null ? 43 : $deploySetting.hashCode());
        Connector $updatedConnector = this.getUpdatedConnector();
        result = result * 59 + ($updatedConnector == null ? 43 : $updatedConnector.hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        MLCreateConnectorInput $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : ((Object)$connector).hashCode());
        Instant $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + ($lastUpdateTime == null ? 43 : ((Object)$lastUpdateTime).hashCode());
        Guardrails $guardrails = this.getGuardrails();
        result = result * 59 + ($guardrails == null ? 43 : ((Object)$guardrails).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Map<String, String> $modelInterface = this.getModelInterface();
        result = result * 59 + ($modelInterface == null ? 43 : ((Object)$modelInterface).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLUpdateModelInput(modelId=" + this.getModelId() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", modelGroupId=" + this.getModelGroupId() + ", isEnabled=" + this.getIsEnabled() + ", rateLimiter=" + String.valueOf(this.getRateLimiter()) + ", modelConfig=" + String.valueOf(this.getModelConfig()) + ", deploySetting=" + String.valueOf(this.getDeploySetting()) + ", updatedConnector=" + String.valueOf(this.getUpdatedConnector()) + ", connectorId=" + this.getConnectorId() + ", connector=" + String.valueOf(this.getConnector()) + ", lastUpdateTime=" + String.valueOf(this.getLastUpdateTime()) + ", guardrails=" + String.valueOf(this.getGuardrails()) + ", tenantId=" + this.getTenantId() + ", modelInterface=" + String.valueOf(this.getModelInterface()) + ")";
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public static class MLUpdateModelInputBuilder {
        @Generated
        private String modelId;
        @Generated
        private String description;
        @Generated
        private String version;
        @Generated
        private String name;
        @Generated
        private String modelGroupId;
        @Generated
        private Boolean isEnabled;
        @Generated
        private MLRateLimiter rateLimiter;
        @Generated
        private MLModelConfig modelConfig;
        @Generated
        private MLDeploySetting deploySetting;
        @Generated
        private Connector updatedConnector;
        @Generated
        private String connectorId;
        @Generated
        private MLCreateConnectorInput connector;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private Guardrails guardrails;
        @Generated
        private Map<String, String> modelInterface;
        @Generated
        private String tenantId;

        @Generated
        MLUpdateModelInputBuilder() {
        }

        @Generated
        public MLUpdateModelInputBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder modelGroupId(String modelGroupId) {
            this.modelGroupId = modelGroupId;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder rateLimiter(MLRateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder modelConfig(MLModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder deploySetting(MLDeploySetting deploySetting) {
            this.deploySetting = deploySetting;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder updatedConnector(Connector updatedConnector) {
            this.updatedConnector = updatedConnector;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder connector(MLCreateConnectorInput connector) {
            this.connector = connector;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder guardrails(Guardrails guardrails) {
            this.guardrails = guardrails;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder modelInterface(Map<String, String> modelInterface) {
            this.modelInterface = modelInterface;
            return this;
        }

        @Generated
        public MLUpdateModelInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLUpdateModelInput build() {
            return new MLUpdateModelInput(this.modelId, this.description, this.version, this.name, this.modelGroupId, this.isEnabled, this.rateLimiter, this.modelConfig, this.deploySetting, this.updatedConnector, this.connectorId, this.connector, this.lastUpdateTime, this.guardrails, this.modelInterface, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MLUpdateModelInput.MLUpdateModelInputBuilder(modelId=" + this.modelId + ", description=" + this.description + ", version=" + this.version + ", name=" + this.name + ", modelGroupId=" + this.modelGroupId + ", isEnabled=" + this.isEnabled + ", rateLimiter=" + String.valueOf(this.rateLimiter) + ", modelConfig=" + String.valueOf(this.modelConfig) + ", deploySetting=" + String.valueOf(this.deploySetting) + ", updatedConnector=" + String.valueOf(this.updatedConnector) + ", connectorId=" + this.connectorId + ", connector=" + String.valueOf(this.connector) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", guardrails=" + String.valueOf(this.guardrails) + ", modelInterface=" + String.valueOf(this.modelInterface) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

