/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RecoveryStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RecoveryStats> {
    private final long currentAsSource;
    private final long currentAsTarget;
    @Nullable
    private final Time throttleTime;
    private final long throttleTimeInMillis;
    public static final JsonpDeserializer<RecoveryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryStats::setupRecoveryStatsDeserializer);

    private RecoveryStats(Builder builder) {
        this.currentAsSource = ApiTypeHelper.requireNonNull(builder.currentAsSource, this, "currentAsSource");
        this.currentAsTarget = ApiTypeHelper.requireNonNull(builder.currentAsTarget, this, "currentAsTarget");
        this.throttleTime = builder.throttleTime;
        this.throttleTimeInMillis = ApiTypeHelper.requireNonNull(builder.throttleTimeInMillis, this, "throttleTimeInMillis");
    }

    public static RecoveryStats of(Function<Builder, ObjectBuilder<RecoveryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long currentAsSource() {
        return this.currentAsSource;
    }

    public final long currentAsTarget() {
        return this.currentAsTarget;
    }

    @Nullable
    public final Time throttleTime() {
        return this.throttleTime;
    }

    public final long throttleTimeInMillis() {
        return this.throttleTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_as_source");
        generator.write(this.currentAsSource);
        generator.writeKey("current_as_target");
        generator.write(this.currentAsTarget);
        if (this.throttleTime != null) {
            generator.writeKey("throttle_time");
            this.throttleTime.serialize(generator, mapper);
        }
        generator.writeKey("throttle_time_in_millis");
        generator.write(this.throttleTimeInMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRecoveryStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentAsSource, JsonpDeserializer.longDeserializer(), "current_as_source");
        op.add(Builder::currentAsTarget, JsonpDeserializer.longDeserializer(), "current_as_target");
        op.add(Builder::throttleTime, Time._DESERIALIZER, "throttle_time");
        op.add(Builder::throttleTimeInMillis, JsonpDeserializer.longDeserializer(), "throttle_time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.currentAsSource);
        result = 31 * result + Long.hashCode(this.currentAsTarget);
        result = 31 * result + Objects.hashCode(this.throttleTime);
        result = 31 * result + Long.hashCode(this.throttleTimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoveryStats other = (RecoveryStats)o;
        return this.currentAsSource == other.currentAsSource && this.currentAsTarget == other.currentAsTarget && Objects.equals(this.throttleTime, other.throttleTime) && this.throttleTimeInMillis == other.throttleTimeInMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RecoveryStats> {
        private Long currentAsSource;
        private Long currentAsTarget;
        @Nullable
        private Time throttleTime;
        private Long throttleTimeInMillis;

        public Builder() {
        }

        private Builder(RecoveryStats o) {
            this.currentAsSource = o.currentAsSource;
            this.currentAsTarget = o.currentAsTarget;
            this.throttleTime = o.throttleTime;
            this.throttleTimeInMillis = o.throttleTimeInMillis;
        }

        private Builder(Builder o) {
            this.currentAsSource = o.currentAsSource;
            this.currentAsTarget = o.currentAsTarget;
            this.throttleTime = o.throttleTime;
            this.throttleTimeInMillis = o.throttleTimeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder currentAsSource(long value) {
            this.currentAsSource = value;
            return this;
        }

        @Nonnull
        public final Builder currentAsTarget(long value) {
            this.currentAsTarget = value;
            return this;
        }

        @Nonnull
        public final Builder throttleTime(@Nullable Time value) {
            this.throttleTime = value;
            return this;
        }

        @Nonnull
        public final Builder throttleTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttleTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder throttleTimeInMillis(long value) {
            this.throttleTimeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public RecoveryStats build() {
            this._checkSingleUse();
            return new RecoveryStats(this);
        }
    }
}

