/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RequestCacheStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RequestCacheStats> {
    private final long evictions;
    private final long hitCount;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    private final long missCount;
    public static final JsonpDeserializer<RequestCacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RequestCacheStats::setupRequestCacheStatsDeserializer);

    private RequestCacheStats(Builder builder) {
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, this, "evictions");
        this.hitCount = ApiTypeHelper.requireNonNull(builder.hitCount, this, "hitCount");
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, this, "memorySizeInBytes");
        this.missCount = ApiTypeHelper.requireNonNull(builder.missCount, this, "missCount");
    }

    public static RequestCacheStats of(Function<Builder, ObjectBuilder<RequestCacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long evictions() {
        return this.evictions;
    }

    public final long hitCount() {
        return this.hitCount;
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public final long missCount() {
        return this.missCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRequestCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::hitCount, JsonpDeserializer.longDeserializer(), "hit_count");
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
        op.add(Builder::missCount, JsonpDeserializer.longDeserializer(), "miss_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.evictions);
        result = 31 * result + Long.hashCode(this.hitCount);
        result = 31 * result + Objects.hashCode(this.memorySize);
        result = 31 * result + Long.hashCode(this.memorySizeInBytes);
        result = 31 * result + Long.hashCode(this.missCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestCacheStats other = (RequestCacheStats)o;
        return this.evictions == other.evictions && this.hitCount == other.hitCount && Objects.equals(this.memorySize, other.memorySize) && this.memorySizeInBytes == other.memorySizeInBytes && this.missCount == other.missCount;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RequestCacheStats> {
        private Long evictions;
        private Long hitCount;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;
        private Long missCount;

        public Builder() {
        }

        private Builder(RequestCacheStats o) {
            this.evictions = o.evictions;
            this.hitCount = o.hitCount;
            this.memorySize = o.memorySize;
            this.memorySizeInBytes = o.memorySizeInBytes;
            this.missCount = o.missCount;
        }

        private Builder(Builder o) {
            this.evictions = o.evictions;
            this.hitCount = o.hitCount;
            this.memorySize = o.memorySize;
            this.memorySizeInBytes = o.memorySizeInBytes;
            this.missCount = o.missCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        @Nonnull
        public final Builder hitCount(long value) {
            this.hitCount = value;
            return this;
        }

        @Nonnull
        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        @Nonnull
        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder missCount(long value) {
            this.missCount = value;
            return this;
        }

        @Override
        @Nonnull
        public RequestCacheStats build() {
            this._checkSingleUse();
            return new RequestCacheStats(this);
        }
    }
}

