/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ScriptLanguage;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class StoredScript
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, StoredScript> {
    @Nonnull
    private final ScriptLanguage lang;
    @Nonnull
    private final Map<String, String> options;
    @Nonnull
    private final String source;
    public static final JsonpDeserializer<StoredScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StoredScript::setupStoredScriptDeserializer);

    private StoredScript(Builder builder) {
        this.lang = ApiTypeHelper.requireNonNull(builder.lang, this, "lang");
        this.options = ApiTypeHelper.unmodifiable(builder.options);
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
    }

    public static StoredScript of(Function<Builder, ObjectBuilder<StoredScript>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final ScriptLanguage lang() {
        return this.lang;
    }

    @Nonnull
    public final Map<String, String> options() {
        return this.options;
    }

    @Nonnull
    public final String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lang");
        this.lang.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.options.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("source");
        generator.write(this.source);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStoredScriptDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lang, ScriptLanguage._DESERIALIZER, "lang");
        op.add(Builder::options, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "options");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.lang.hashCode();
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredScript other = (StoredScript)o;
        return this.lang.equals(other.lang) && Objects.equals(this.options, other.options) && this.source.equals(other.source);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, StoredScript> {
        private ScriptLanguage lang;
        @Nullable
        private Map<String, String> options;
        private String source;

        public Builder() {
        }

        private Builder(StoredScript o) {
            this.lang = o.lang;
            this.options = Builder._mapCopy(o.options);
            this.source = o.source;
        }

        private Builder(Builder o) {
            this.lang = o.lang;
            this.options = Builder._mapCopy(o.options);
            this.source = o.source;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder lang(ScriptLanguage value) {
            this.lang = value;
            return this;
        }

        @Nonnull
        public final Builder lang(Function<ScriptLanguage.Builder, ObjectBuilder<ScriptLanguage>> fn) {
            return this.lang(fn.apply(new ScriptLanguage.Builder()).build());
        }

        @Nonnull
        public final Builder options(Map<String, String> map) {
            this.options = Builder._mapPutAll(this.options, map);
            return this;
        }

        @Nonnull
        public final Builder options(String key, String value) {
            this.options = Builder._mapPut(this.options, key, value);
            return this;
        }

        @Nonnull
        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        @Override
        @Nonnull
        public StoredScript build() {
            this._checkSingleUse();
            return new StoredScript(this);
        }
    }
}

