/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class LengthTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, LengthTokenFilter> {
    @Nullable
    private final Integer max;
    @Nullable
    private final Integer min;
    public static final JsonpDeserializer<LengthTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LengthTokenFilter::setupLengthTokenFilterDeserializer);

    private LengthTokenFilter(Builder builder) {
        super(builder);
        this.max = builder.max;
        this.min = builder.min;
    }

    public static LengthTokenFilter of(Function<Builder, ObjectBuilder<LengthTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Length;
    }

    @Nullable
    public final Integer max() {
        return this.max;
    }

    @Nullable
    public final Integer min() {
        return this.min;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "length");
        super.serializeInternal(generator, mapper);
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max.intValue());
        }
        if (this.min != null) {
            generator.writeKey("min");
            generator.write(this.min.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupLengthTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        LengthTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max");
        op.add(Builder::min, JsonpDeserializer.integerDeserializer(), "min");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.max);
        result = 31 * result + Objects.hashCode(this.min);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LengthTokenFilter other = (LengthTokenFilter)o;
        return Objects.equals(this.max, other.max) && Objects.equals(this.min, other.min);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, LengthTokenFilter> {
        @Nullable
        private Integer max;
        @Nullable
        private Integer min;

        public Builder() {
        }

        private Builder(LengthTokenFilter o) {
            super(o);
            this.max = o.max;
            this.min = o.min;
        }

        private Builder(Builder o) {
            super(o);
            this.max = o.max;
            this.min = o.min;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder max(@Nullable Integer value) {
            this.max = value;
            return this;
        }

        @Nonnull
        public final Builder min(@Nullable Integer value) {
            this.min = value;
            return this;
        }

        @Override
        @Nonnull
        public LengthTokenFilter build() {
            this._checkSingleUse();
            return new LengthTokenFilter(this);
        }
    }
}

