/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainDeserializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.AllField;
import org.opensearch.client.opensearch._types.mapping.DataStreamTimestamp;
import org.opensearch.client.opensearch._types.mapping.DynamicMapping;
import org.opensearch.client.opensearch._types.mapping.DynamicTemplate;
import org.opensearch.client.opensearch._types.mapping.FieldNamesField;
import org.opensearch.client.opensearch._types.mapping.IndexField;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.RoutingField;
import org.opensearch.client.opensearch._types.mapping.SizeField;
import org.opensearch.client.opensearch._types.mapping.SourceField;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TypeMapping
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TypeMapping> {
    @Nullable
    private final AllField allField;
    @Nullable
    private final DataStreamTimestamp dataStreamTimestamp;
    @Nullable
    private final Boolean dateDetection;
    @Nullable
    private final DynamicMapping dynamic;
    @Nonnull
    private final List<String> dynamicDateFormats;
    @Nonnull
    private final List<Map<String, DynamicTemplate>> dynamicTemplates;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final FieldNamesField fieldNames;
    @Nullable
    private final IndexField indexField;
    @Nonnull
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean numericDetection;
    @Nonnull
    private final Map<String, Property> properties;
    @Nullable
    private final RoutingField routing;
    @Nullable
    private final SizeField size;
    @Nullable
    private final SourceField source;
    public static final JsonpDeserializer<TypeMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TypeMapping::setupTypeMappingDeserializer);

    private TypeMapping(Builder builder) {
        this.allField = builder.allField;
        this.dataStreamTimestamp = builder.dataStreamTimestamp;
        this.dateDetection = builder.dateDetection;
        this.dynamic = builder.dynamic;
        this.dynamicDateFormats = ApiTypeHelper.unmodifiable(builder.dynamicDateFormats);
        this.dynamicTemplates = ApiTypeHelper.unmodifiable(builder.dynamicTemplates);
        this.enabled = builder.enabled;
        this.fieldNames = builder.fieldNames;
        this.indexField = builder.indexField;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.numericDetection = builder.numericDetection;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.routing = builder.routing;
        this.size = builder.size;
        this.source = builder.source;
    }

    public static TypeMapping of(Function<Builder, ObjectBuilder<TypeMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AllField allField() {
        return this.allField;
    }

    @Nullable
    public final DataStreamTimestamp dataStreamTimestamp() {
        return this.dataStreamTimestamp;
    }

    @Nullable
    public final Boolean dateDetection() {
        return this.dateDetection;
    }

    @Nullable
    public final DynamicMapping dynamic() {
        return this.dynamic;
    }

    @Nonnull
    public final List<String> dynamicDateFormats() {
        return this.dynamicDateFormats;
    }

    @Nonnull
    public final List<Map<String, DynamicTemplate>> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final FieldNamesField fieldNames() {
        return this.fieldNames;
    }

    @Nullable
    public final IndexField indexField() {
        return this.indexField;
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean numericDetection() {
        return this.numericDetection;
    }

    @Nonnull
    public final Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public final RoutingField routing() {
        return this.routing;
    }

    @Nullable
    public final SizeField size() {
        return this.size;
    }

    @Nullable
    public final SourceField source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allField != null) {
            generator.writeKey("all_field");
            this.allField.serialize(generator, mapper);
        }
        if (this.dataStreamTimestamp != null) {
            generator.writeKey("_data_stream_timestamp");
            this.dataStreamTimestamp.serialize(generator, mapper);
        }
        if (this.dateDetection != null) {
            generator.writeKey("date_detection");
            generator.write(this.dateDetection.booleanValue());
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            this.dynamic.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.dynamicDateFormats)) {
            generator.writeKey("dynamic_date_formats");
            generator.writeStartArray();
            for (String string : this.dynamicDateFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.dynamicTemplates)) {
            generator.writeKey("dynamic_templates");
            generator.writeStartArray();
            for (Map map : this.dynamicTemplates) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((DynamicTemplate)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.fieldNames != null) {
            generator.writeKey("_field_names");
            this.fieldNames.serialize(generator, mapper);
        }
        if (this.indexField != null) {
            generator.writeKey("index_field");
            this.indexField.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.numericDetection != null) {
            generator.writeKey("numeric_detection");
            generator.write(this.numericDetection.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry entry : this.properties.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            this.routing.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("_size");
            this.size.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTypeMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allField, AllField._DESERIALIZER, "all_field");
        op.add(Builder::dataStreamTimestamp, DataStreamTimestamp._DESERIALIZER, "_data_stream_timestamp");
        op.add(Builder::dateDetection, JsonpDeserializer.booleanDeserializer(), "date_detection");
        op.add(Builder::dynamic, DynamicMapping._DESERIALIZER, "dynamic");
        op.add(Builder::dynamicDateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dynamic_date_formats");
        op.add(Builder::dynamicTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(DynamicTemplate._DESERIALIZER)), "dynamic_templates");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::fieldNames, FieldNamesField._DESERIALIZER, "_field_names");
        op.add(Builder::indexField, IndexField._DESERIALIZER, "index_field");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::numericDetection, JsonpDeserializer.booleanDeserializer(), "numeric_detection");
        op.add(Builder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties");
        op.add(Builder::routing, RoutingField._DESERIALIZER, "_routing");
        op.add(Builder::size, SizeField._DESERIALIZER, "_size");
        op.add(Builder::source, SourceField._DESERIALIZER, "_source");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allField);
        result = 31 * result + Objects.hashCode(this.dataStreamTimestamp);
        result = 31 * result + Objects.hashCode(this.dateDetection);
        result = 31 * result + Objects.hashCode(this.dynamic);
        result = 31 * result + Objects.hashCode(this.dynamicDateFormats);
        result = 31 * result + Objects.hashCode(this.dynamicTemplates);
        result = 31 * result + Objects.hashCode(this.enabled);
        result = 31 * result + Objects.hashCode(this.fieldNames);
        result = 31 * result + Objects.hashCode(this.indexField);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + Objects.hashCode(this.numericDetection);
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.source);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeMapping other = (TypeMapping)o;
        return Objects.equals(this.allField, other.allField) && Objects.equals(this.dataStreamTimestamp, other.dataStreamTimestamp) && Objects.equals(this.dateDetection, other.dateDetection) && Objects.equals(this.dynamic, other.dynamic) && Objects.equals(this.dynamicDateFormats, other.dynamicDateFormats) && Objects.equals(this.dynamicTemplates, other.dynamicTemplates) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.fieldNames, other.fieldNames) && Objects.equals(this.indexField, other.indexField) && Objects.equals(this.meta, other.meta) && Objects.equals(this.numericDetection, other.numericDetection) && Objects.equals(this.properties, other.properties) && Objects.equals(this.routing, other.routing) && Objects.equals(this.size, other.size) && Objects.equals(this.source, other.source);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TypeMapping>,
    PlainDeserializable<Builder> {
        @Nullable
        private AllField allField;
        @Nullable
        private DataStreamTimestamp dataStreamTimestamp;
        @Nullable
        private Boolean dateDetection;
        @Nullable
        private DynamicMapping dynamic;
        @Nullable
        private List<String> dynamicDateFormats;
        @Nullable
        private List<Map<String, DynamicTemplate>> dynamicTemplates;
        @Nullable
        private Boolean enabled;
        @Nullable
        private FieldNamesField fieldNames;
        @Nullable
        private IndexField indexField;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean numericDetection;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private RoutingField routing;
        @Nullable
        private SizeField size;
        @Nullable
        private SourceField source;

        public Builder() {
        }

        private Builder(TypeMapping o) {
            this.allField = o.allField;
            this.dataStreamTimestamp = o.dataStreamTimestamp;
            this.dateDetection = o.dateDetection;
            this.dynamic = o.dynamic;
            this.dynamicDateFormats = Builder._listCopy(o.dynamicDateFormats);
            this.dynamicTemplates = Builder._listCopy(o.dynamicTemplates);
            this.enabled = o.enabled;
            this.fieldNames = o.fieldNames;
            this.indexField = o.indexField;
            this.meta = Builder._mapCopy(o.meta);
            this.numericDetection = o.numericDetection;
            this.properties = Builder._mapCopy(o.properties);
            this.routing = o.routing;
            this.size = o.size;
            this.source = o.source;
        }

        private Builder(Builder o) {
            this.allField = o.allField;
            this.dataStreamTimestamp = o.dataStreamTimestamp;
            this.dateDetection = o.dateDetection;
            this.dynamic = o.dynamic;
            this.dynamicDateFormats = Builder._listCopy(o.dynamicDateFormats);
            this.dynamicTemplates = Builder._listCopy(o.dynamicTemplates);
            this.enabled = o.enabled;
            this.fieldNames = o.fieldNames;
            this.indexField = o.indexField;
            this.meta = Builder._mapCopy(o.meta);
            this.numericDetection = o.numericDetection;
            this.properties = Builder._mapCopy(o.properties);
            this.routing = o.routing;
            this.size = o.size;
            this.source = o.source;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        public Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allField(@Nullable AllField value) {
            this.allField = value;
            return this;
        }

        @Nonnull
        public final Builder allField(Function<AllField.Builder, ObjectBuilder<AllField>> fn) {
            return this.allField(fn.apply(new AllField.Builder()).build());
        }

        @Nonnull
        public final Builder dataStreamTimestamp(@Nullable DataStreamTimestamp value) {
            this.dataStreamTimestamp = value;
            return this;
        }

        @Nonnull
        public final Builder dataStreamTimestamp(Function<DataStreamTimestamp.Builder, ObjectBuilder<DataStreamTimestamp>> fn) {
            return this.dataStreamTimestamp(fn.apply(new DataStreamTimestamp.Builder()).build());
        }

        @Nonnull
        public final Builder dateDetection(@Nullable Boolean value) {
            this.dateDetection = value;
            return this;
        }

        @Nonnull
        public final Builder dynamic(@Nullable DynamicMapping value) {
            this.dynamic = value;
            return this;
        }

        @Nonnull
        public final Builder dynamicDateFormats(List<String> list) {
            this.dynamicDateFormats = Builder._listAddAll(this.dynamicDateFormats, list);
            return this;
        }

        @Nonnull
        public final Builder dynamicDateFormats(String value, String ... values) {
            this.dynamicDateFormats = Builder._listAdd(this.dynamicDateFormats, value, values);
            return this;
        }

        @Nonnull
        public final Builder dynamicTemplates(List<Map<String, DynamicTemplate>> list) {
            this.dynamicTemplates = Builder._listAddAll(this.dynamicTemplates, list);
            return this;
        }

        @Nonnull
        public final Builder dynamicTemplates(Map<String, DynamicTemplate> value, Map<String, DynamicTemplate> ... values) {
            this.dynamicTemplates = Builder._listAdd(this.dynamicTemplates, value, values);
            return this;
        }

        @Nonnull
        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public final Builder fieldNames(@Nullable FieldNamesField value) {
            this.fieldNames = value;
            return this;
        }

        @Nonnull
        public final Builder fieldNames(Function<FieldNamesField.Builder, ObjectBuilder<FieldNamesField>> fn) {
            return this.fieldNames(fn.apply(new FieldNamesField.Builder()).build());
        }

        @Nonnull
        public final Builder indexField(@Nullable IndexField value) {
            this.indexField = value;
            return this;
        }

        @Nonnull
        public final Builder indexField(Function<IndexField.Builder, ObjectBuilder<IndexField>> fn) {
            return this.indexField(fn.apply(new IndexField.Builder()).build());
        }

        @Nonnull
        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder numericDetection(@Nullable Boolean value) {
            this.numericDetection = value;
            return this;
        }

        @Nonnull
        public final Builder properties(Map<String, Property> map) {
            this.properties = Builder._mapPutAll(this.properties, map);
            return this;
        }

        @Nonnull
        public final Builder properties(String key, Property value) {
            this.properties = Builder._mapPut(this.properties, key, value);
            return this;
        }

        @Nonnull
        public final Builder properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(key, fn.apply(new Property.Builder()).build());
        }

        @Nonnull
        public final Builder routing(@Nullable RoutingField value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder routing(Function<RoutingField.Builder, ObjectBuilder<RoutingField>> fn) {
            return this.routing(fn.apply(new RoutingField.Builder()).build());
        }

        @Nonnull
        public final Builder size(@Nullable SizeField value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder size(Function<SizeField.Builder, ObjectBuilder<SizeField>> fn) {
            return this.size(fn.apply(new SizeField.Builder()).build());
        }

        @Nonnull
        public final Builder source(@Nullable SourceField value) {
            this.source = value;
            return this;
        }

        @Nonnull
        public final Builder source(Function<SourceField.Builder, ObjectBuilder<SourceField>> fn) {
            return this.source(fn.apply(new SourceField.Builder()).build());
        }

        @Override
        @Nonnull
        public TypeMapping build() {
            this._checkSingleUse();
            return new TypeMapping(this);
        }
    }
}

