/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterFileSystem
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterFileSystem> {
    @Nullable
    private final String available;
    private final long availableInBytes;
    @Nullable
    private final String cacheReserved;
    @Nullable
    private final Long cacheReservedInBytes;
    @Nullable
    private final String free;
    private final long freeInBytes;
    @Nullable
    private final String total;
    private final long totalInBytes;
    public static final JsonpDeserializer<ClusterFileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterFileSystem::setupClusterFileSystemDeserializer);

    private ClusterFileSystem(Builder builder) {
        this.available = builder.available;
        this.availableInBytes = ApiTypeHelper.requireNonNull(builder.availableInBytes, this, "availableInBytes");
        this.cacheReserved = builder.cacheReserved;
        this.cacheReservedInBytes = builder.cacheReservedInBytes;
        this.free = builder.free;
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, this, "freeInBytes");
        this.total = builder.total;
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
    }

    public static ClusterFileSystem of(Function<Builder, ObjectBuilder<ClusterFileSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String available() {
        return this.available;
    }

    public final long availableInBytes() {
        return this.availableInBytes;
    }

    @Nullable
    public final String cacheReserved() {
        return this.cacheReserved;
    }

    @Nullable
    public final Long cacheReservedInBytes() {
        return this.cacheReservedInBytes;
    }

    @Nullable
    public final String free() {
        return this.free;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.available != null) {
            generator.writeKey("available");
            generator.write(this.available);
        }
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        if (this.cacheReserved != null) {
            generator.writeKey("cache_reserved");
            generator.write(this.cacheReserved);
        }
        if (this.cacheReservedInBytes != null) {
            generator.writeKey("cache_reserved_in_bytes");
            generator.write(this.cacheReservedInBytes.longValue());
        }
        if (this.free != null) {
            generator.writeKey("free");
            generator.write(this.free);
        }
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterFileSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.stringDeserializer(), "available");
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::cacheReserved, JsonpDeserializer.stringDeserializer(), "cache_reserved");
        op.add(Builder::cacheReservedInBytes, JsonpDeserializer.longDeserializer(), "cache_reserved_in_bytes");
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.available);
        result = 31 * result + Long.hashCode(this.availableInBytes);
        result = 31 * result + Objects.hashCode(this.cacheReserved);
        result = 31 * result + Objects.hashCode(this.cacheReservedInBytes);
        result = 31 * result + Objects.hashCode(this.free);
        result = 31 * result + Long.hashCode(this.freeInBytes);
        result = 31 * result + Objects.hashCode(this.total);
        result = 31 * result + Long.hashCode(this.totalInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterFileSystem other = (ClusterFileSystem)o;
        return Objects.equals(this.available, other.available) && this.availableInBytes == other.availableInBytes && Objects.equals(this.cacheReserved, other.cacheReserved) && Objects.equals(this.cacheReservedInBytes, other.cacheReservedInBytes) && Objects.equals(this.free, other.free) && this.freeInBytes == other.freeInBytes && Objects.equals(this.total, other.total) && this.totalInBytes == other.totalInBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterFileSystem> {
        @Nullable
        private String available;
        private Long availableInBytes;
        @Nullable
        private String cacheReserved;
        @Nullable
        private Long cacheReservedInBytes;
        @Nullable
        private String free;
        private Long freeInBytes;
        @Nullable
        private String total;
        private Long totalInBytes;

        public Builder() {
        }

        private Builder(ClusterFileSystem o) {
            this.available = o.available;
            this.availableInBytes = o.availableInBytes;
            this.cacheReserved = o.cacheReserved;
            this.cacheReservedInBytes = o.cacheReservedInBytes;
            this.free = o.free;
            this.freeInBytes = o.freeInBytes;
            this.total = o.total;
            this.totalInBytes = o.totalInBytes;
        }

        private Builder(Builder o) {
            this.available = o.available;
            this.availableInBytes = o.availableInBytes;
            this.cacheReserved = o.cacheReserved;
            this.cacheReservedInBytes = o.cacheReservedInBytes;
            this.free = o.free;
            this.freeInBytes = o.freeInBytes;
            this.total = o.total;
            this.totalInBytes = o.totalInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder available(@Nullable String value) {
            this.available = value;
            return this;
        }

        @Nonnull
        public final Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder cacheReserved(@Nullable String value) {
            this.cacheReserved = value;
            return this;
        }

        @Nonnull
        public final Builder cacheReservedInBytes(@Nullable Long value) {
            this.cacheReservedInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder free(@Nullable String value) {
            this.free = value;
            return this;
        }

        @Nonnull
        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterFileSystem build() {
            this._checkSingleUse();
            return new ClusterFileSystem(this);
        }
    }
}

