/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.search.BoundaryScanner;
import org.opensearch.client.opensearch.core.search.HighlighterFragmenter;
import org.opensearch.client.opensearch.core.search.HighlighterOrder;
import org.opensearch.client.opensearch.core.search.HighlighterTagsSchema;
import org.opensearch.client.opensearch.core.search.HighlighterType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class HighlightBase
implements PlainJsonSerializable {
    @Nullable
    private final String boundaryChars;
    @Nullable
    private final Integer boundaryMaxScan;
    @Nullable
    private final BoundaryScanner boundaryScanner;
    @Nullable
    private final String boundaryScannerLocale;
    @Nullable
    private final Boolean forceSource;
    @Nullable
    private final Integer fragmentOffset;
    @Nullable
    private final Integer fragmentSize;
    @Nullable
    private final HighlighterFragmenter fragmenter;
    @Nullable
    private final Boolean highlightFilter;
    @Nullable
    private final Query highlightQuery;
    @Nullable
    private final Integer maxAnalyzerOffset;
    @Nullable
    private final Integer maxFragmentLength;
    @Nullable
    private final Integer noMatchSize;
    @Nullable
    private final Integer numberOfFragments;
    @Nonnull
    private final Map<String, Map<String, JsonData>> options;
    @Nullable
    private final HighlighterOrder order;
    @Nullable
    private final Integer phraseLimit;
    @Nonnull
    private final List<String> postTags;
    @Nonnull
    private final List<String> preTags;
    @Nullable
    private final Boolean requireFieldMatch;
    @Nullable
    private final HighlighterTagsSchema tagsSchema;
    @Nullable
    private final HighlighterType type;

    protected HighlightBase(AbstractBuilder<?> builder) {
        this.boundaryChars = ((AbstractBuilder)builder).boundaryChars;
        this.boundaryMaxScan = ((AbstractBuilder)builder).boundaryMaxScan;
        this.boundaryScanner = ((AbstractBuilder)builder).boundaryScanner;
        this.boundaryScannerLocale = ((AbstractBuilder)builder).boundaryScannerLocale;
        this.forceSource = ((AbstractBuilder)builder).forceSource;
        this.fragmentOffset = ((AbstractBuilder)builder).fragmentOffset;
        this.fragmentSize = ((AbstractBuilder)builder).fragmentSize;
        this.fragmenter = ((AbstractBuilder)builder).fragmenter;
        this.highlightFilter = ((AbstractBuilder)builder).highlightFilter;
        this.highlightQuery = ((AbstractBuilder)builder).highlightQuery;
        this.maxAnalyzerOffset = ((AbstractBuilder)builder).maxAnalyzerOffset;
        this.maxFragmentLength = ((AbstractBuilder)builder).maxFragmentLength;
        this.noMatchSize = ((AbstractBuilder)builder).noMatchSize;
        this.numberOfFragments = ((AbstractBuilder)builder).numberOfFragments;
        this.options = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).options);
        this.order = ((AbstractBuilder)builder).order;
        this.phraseLimit = ((AbstractBuilder)builder).phraseLimit;
        this.postTags = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).postTags);
        this.preTags = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).preTags);
        this.requireFieldMatch = ((AbstractBuilder)builder).requireFieldMatch;
        this.tagsSchema = ((AbstractBuilder)builder).tagsSchema;
        this.type = ((AbstractBuilder)builder).type;
    }

    @Nullable
    public final String boundaryChars() {
        return this.boundaryChars;
    }

    @Nullable
    public final Integer boundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    @Nullable
    public final BoundaryScanner boundaryScanner() {
        return this.boundaryScanner;
    }

    @Nullable
    public final String boundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    @Nullable
    public final Boolean forceSource() {
        return this.forceSource;
    }

    @Nullable
    public final Integer fragmentOffset() {
        return this.fragmentOffset;
    }

    @Nullable
    public final Integer fragmentSize() {
        return this.fragmentSize;
    }

    @Nullable
    public final HighlighterFragmenter fragmenter() {
        return this.fragmenter;
    }

    @Nullable
    public final Boolean highlightFilter() {
        return this.highlightFilter;
    }

    @Nullable
    public final Query highlightQuery() {
        return this.highlightQuery;
    }

    @Nullable
    public final Integer maxAnalyzerOffset() {
        return this.maxAnalyzerOffset;
    }

    @Nullable
    public final Integer maxFragmentLength() {
        return this.maxFragmentLength;
    }

    @Nullable
    public final Integer noMatchSize() {
        return this.noMatchSize;
    }

    @Nullable
    public final Integer numberOfFragments() {
        return this.numberOfFragments;
    }

    @Nonnull
    public final Map<String, Map<String, JsonData>> options() {
        return this.options;
    }

    @Nullable
    public final HighlighterOrder order() {
        return this.order;
    }

    @Nullable
    public final Integer phraseLimit() {
        return this.phraseLimit;
    }

    @Nonnull
    public final List<String> postTags() {
        return this.postTags;
    }

    @Nonnull
    public final List<String> preTags() {
        return this.preTags;
    }

    @Nullable
    public final Boolean requireFieldMatch() {
        return this.requireFieldMatch;
    }

    @Nullable
    public final HighlighterTagsSchema tagsSchema() {
        return this.tagsSchema;
    }

    @Nullable
    public final HighlighterType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.boundaryChars != null) {
            generator.writeKey("boundary_chars");
            generator.write(this.boundaryChars);
        }
        if (this.boundaryMaxScan != null) {
            generator.writeKey("boundary_max_scan");
            generator.write(this.boundaryMaxScan.intValue());
        }
        if (this.boundaryScanner != null) {
            generator.writeKey("boundary_scanner");
            this.boundaryScanner.serialize(generator, mapper);
        }
        if (this.boundaryScannerLocale != null) {
            generator.writeKey("boundary_scanner_locale");
            generator.write(this.boundaryScannerLocale);
        }
        if (this.forceSource != null) {
            generator.writeKey("force_source");
            generator.write(this.forceSource.booleanValue());
        }
        if (this.fragmentOffset != null) {
            generator.writeKey("fragment_offset");
            generator.write(this.fragmentOffset.intValue());
        }
        if (this.fragmentSize != null) {
            generator.writeKey("fragment_size");
            generator.write(this.fragmentSize.intValue());
        }
        if (this.fragmenter != null) {
            generator.writeKey("fragmenter");
            this.fragmenter.serialize(generator, mapper);
        }
        if (this.highlightFilter != null) {
            generator.writeKey("highlight_filter");
            generator.write(this.highlightFilter.booleanValue());
        }
        if (this.highlightQuery != null) {
            generator.writeKey("highlight_query");
            this.highlightQuery.serialize(generator, mapper);
        }
        if (this.maxAnalyzerOffset != null) {
            generator.writeKey("max_analyzer_offset");
            generator.write(this.maxAnalyzerOffset.intValue());
        }
        if (this.maxFragmentLength != null) {
            generator.writeKey("max_fragment_length");
            generator.write(this.maxFragmentLength.intValue());
        }
        if (this.noMatchSize != null) {
            generator.writeKey("no_match_size");
            generator.write(this.noMatchSize.intValue());
        }
        if (this.numberOfFragments != null) {
            generator.writeKey("number_of_fragments");
            generator.write(this.numberOfFragments.intValue());
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, Map<String, JsonData>> entry : this.options.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartObject();
                for (Map.Entry<String, JsonData> item1 : entry.getValue().entrySet()) {
                    generator.writeKey(item1.getKey());
                    item1.getValue().serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.phraseLimit != null) {
            generator.writeKey("phrase_limit");
            generator.write(this.phraseLimit.intValue());
        }
        if (ApiTypeHelper.isDefined(this.postTags)) {
            generator.writeKey("post_tags");
            generator.writeStartArray();
            for (String string : this.postTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.preTags)) {
            generator.writeKey("pre_tags");
            generator.writeStartArray();
            for (String string : this.preTags) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.requireFieldMatch != null) {
            generator.writeKey("require_field_match");
            generator.write(this.requireFieldMatch.booleanValue());
        }
        if (this.tagsSchema != null) {
            generator.writeKey("tags_schema");
            this.tagsSchema.serialize(generator, mapper);
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupHighlightBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::boundaryChars, JsonpDeserializer.stringDeserializer(), "boundary_chars");
        op.add(AbstractBuilder::boundaryMaxScan, JsonpDeserializer.integerDeserializer(), "boundary_max_scan");
        op.add(AbstractBuilder::boundaryScanner, BoundaryScanner._DESERIALIZER, "boundary_scanner");
        op.add(AbstractBuilder::boundaryScannerLocale, JsonpDeserializer.stringDeserializer(), "boundary_scanner_locale");
        op.add(AbstractBuilder::forceSource, JsonpDeserializer.booleanDeserializer(), "force_source");
        op.add(AbstractBuilder::fragmentOffset, JsonpDeserializer.integerDeserializer(), "fragment_offset");
        op.add(AbstractBuilder::fragmentSize, JsonpDeserializer.integerDeserializer(), "fragment_size");
        op.add(AbstractBuilder::fragmenter, HighlighterFragmenter._DESERIALIZER, "fragmenter");
        op.add(AbstractBuilder::highlightFilter, JsonpDeserializer.booleanDeserializer(), "highlight_filter");
        op.add(AbstractBuilder::highlightQuery, Query._DESERIALIZER, "highlight_query");
        op.add(AbstractBuilder::maxAnalyzerOffset, JsonpDeserializer.integerDeserializer(), "max_analyzer_offset");
        op.add(AbstractBuilder::maxFragmentLength, JsonpDeserializer.integerDeserializer(), "max_fragment_length");
        op.add(AbstractBuilder::noMatchSize, JsonpDeserializer.integerDeserializer(), "no_match_size");
        op.add(AbstractBuilder::numberOfFragments, JsonpDeserializer.integerDeserializer(), "number_of_fragments");
        op.add(AbstractBuilder::options, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "options");
        op.add(AbstractBuilder::order, HighlighterOrder._DESERIALIZER, "order");
        op.add(AbstractBuilder::phraseLimit, JsonpDeserializer.integerDeserializer(), "phrase_limit");
        op.add(AbstractBuilder::postTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "post_tags");
        op.add(AbstractBuilder::preTags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "pre_tags");
        op.add(AbstractBuilder::requireFieldMatch, JsonpDeserializer.booleanDeserializer(), "require_field_match");
        op.add(AbstractBuilder::tagsSchema, HighlighterTagsSchema._DESERIALIZER, "tags_schema");
        op.add(AbstractBuilder::type, HighlighterType._DESERIALIZER, "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.boundaryChars);
        result = 31 * result + Objects.hashCode(this.boundaryMaxScan);
        result = 31 * result + Objects.hashCode(this.boundaryScanner);
        result = 31 * result + Objects.hashCode(this.boundaryScannerLocale);
        result = 31 * result + Objects.hashCode(this.forceSource);
        result = 31 * result + Objects.hashCode(this.fragmentOffset);
        result = 31 * result + Objects.hashCode(this.fragmentSize);
        result = 31 * result + Objects.hashCode(this.fragmenter);
        result = 31 * result + Objects.hashCode(this.highlightFilter);
        result = 31 * result + Objects.hashCode(this.highlightQuery);
        result = 31 * result + Objects.hashCode(this.maxAnalyzerOffset);
        result = 31 * result + Objects.hashCode(this.maxFragmentLength);
        result = 31 * result + Objects.hashCode(this.noMatchSize);
        result = 31 * result + Objects.hashCode(this.numberOfFragments);
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + Objects.hashCode(this.order);
        result = 31 * result + Objects.hashCode(this.phraseLimit);
        result = 31 * result + Objects.hashCode(this.postTags);
        result = 31 * result + Objects.hashCode(this.preTags);
        result = 31 * result + Objects.hashCode(this.requireFieldMatch);
        result = 31 * result + Objects.hashCode(this.tagsSchema);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighlightBase other = (HighlightBase)o;
        return Objects.equals(this.boundaryChars, other.boundaryChars) && Objects.equals(this.boundaryMaxScan, other.boundaryMaxScan) && Objects.equals(this.boundaryScanner, other.boundaryScanner) && Objects.equals(this.boundaryScannerLocale, other.boundaryScannerLocale) && Objects.equals(this.forceSource, other.forceSource) && Objects.equals(this.fragmentOffset, other.fragmentOffset) && Objects.equals(this.fragmentSize, other.fragmentSize) && Objects.equals(this.fragmenter, other.fragmenter) && Objects.equals(this.highlightFilter, other.highlightFilter) && Objects.equals(this.highlightQuery, other.highlightQuery) && Objects.equals(this.maxAnalyzerOffset, other.maxAnalyzerOffset) && Objects.equals(this.maxFragmentLength, other.maxFragmentLength) && Objects.equals(this.noMatchSize, other.noMatchSize) && Objects.equals(this.numberOfFragments, other.numberOfFragments) && Objects.equals(this.options, other.options) && Objects.equals(this.order, other.order) && Objects.equals(this.phraseLimit, other.phraseLimit) && Objects.equals(this.postTags, other.postTags) && Objects.equals(this.preTags, other.preTags) && Objects.equals(this.requireFieldMatch, other.requireFieldMatch) && Objects.equals(this.tagsSchema, other.tagsSchema) && Objects.equals(this.type, other.type);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String boundaryChars;
        @Nullable
        private Integer boundaryMaxScan;
        @Nullable
        private BoundaryScanner boundaryScanner;
        @Nullable
        private String boundaryScannerLocale;
        @Nullable
        private Boolean forceSource;
        @Nullable
        private Integer fragmentOffset;
        @Nullable
        private Integer fragmentSize;
        @Nullable
        private HighlighterFragmenter fragmenter;
        @Nullable
        private Boolean highlightFilter;
        @Nullable
        private Query highlightQuery;
        @Nullable
        private Integer maxAnalyzerOffset;
        @Nullable
        private Integer maxFragmentLength;
        @Nullable
        private Integer noMatchSize;
        @Nullable
        private Integer numberOfFragments;
        @Nullable
        private Map<String, Map<String, JsonData>> options;
        @Nullable
        private HighlighterOrder order;
        @Nullable
        private Integer phraseLimit;
        @Nullable
        private List<String> postTags;
        @Nullable
        private List<String> preTags;
        @Nullable
        private Boolean requireFieldMatch;
        @Nullable
        private HighlighterTagsSchema tagsSchema;
        @Nullable
        private HighlighterType type;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(HighlightBase o) {
            this.boundaryChars = o.boundaryChars;
            this.boundaryMaxScan = o.boundaryMaxScan;
            this.boundaryScanner = o.boundaryScanner;
            this.boundaryScannerLocale = o.boundaryScannerLocale;
            this.forceSource = o.forceSource;
            this.fragmentOffset = o.fragmentOffset;
            this.fragmentSize = o.fragmentSize;
            this.fragmenter = o.fragmenter;
            this.highlightFilter = o.highlightFilter;
            this.highlightQuery = o.highlightQuery;
            this.maxAnalyzerOffset = o.maxAnalyzerOffset;
            this.maxFragmentLength = o.maxFragmentLength;
            this.noMatchSize = o.noMatchSize;
            this.numberOfFragments = o.numberOfFragments;
            this.options = AbstractBuilder._mapCopy(o.options);
            this.order = o.order;
            this.phraseLimit = o.phraseLimit;
            this.postTags = AbstractBuilder._listCopy(o.postTags);
            this.preTags = AbstractBuilder._listCopy(o.preTags);
            this.requireFieldMatch = o.requireFieldMatch;
            this.tagsSchema = o.tagsSchema;
            this.type = o.type;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.boundaryChars = o.boundaryChars;
            this.boundaryMaxScan = o.boundaryMaxScan;
            this.boundaryScanner = o.boundaryScanner;
            this.boundaryScannerLocale = o.boundaryScannerLocale;
            this.forceSource = o.forceSource;
            this.fragmentOffset = o.fragmentOffset;
            this.fragmentSize = o.fragmentSize;
            this.fragmenter = o.fragmenter;
            this.highlightFilter = o.highlightFilter;
            this.highlightQuery = o.highlightQuery;
            this.maxAnalyzerOffset = o.maxAnalyzerOffset;
            this.maxFragmentLength = o.maxFragmentLength;
            this.noMatchSize = o.noMatchSize;
            this.numberOfFragments = o.numberOfFragments;
            this.options = AbstractBuilder._mapCopy(o.options);
            this.order = o.order;
            this.phraseLimit = o.phraseLimit;
            this.postTags = AbstractBuilder._listCopy(o.postTags);
            this.preTags = AbstractBuilder._listCopy(o.preTags);
            this.requireFieldMatch = o.requireFieldMatch;
            this.tagsSchema = o.tagsSchema;
            this.type = o.type;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT boundaryChars(@Nullable String value) {
            this.boundaryChars = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT boundaryMaxScan(@Nullable Integer value) {
            this.boundaryMaxScan = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT boundaryScanner(@Nullable BoundaryScanner value) {
            this.boundaryScanner = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT boundaryScannerLocale(@Nullable String value) {
            this.boundaryScannerLocale = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT forceSource(@Nullable Boolean value) {
            this.forceSource = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT fragmentOffset(@Nullable Integer value) {
            this.fragmentOffset = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT fragmentSize(@Nullable Integer value) {
            this.fragmentSize = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT fragmenter(@Nullable HighlighterFragmenter value) {
            this.fragmenter = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT highlightFilter(@Nullable Boolean value) {
            this.highlightFilter = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT highlightQuery(@Nullable Query value) {
            this.highlightQuery = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT highlightQuery(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.highlightQuery(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final BuilderT maxAnalyzerOffset(@Nullable Integer value) {
            this.maxAnalyzerOffset = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT maxFragmentLength(@Nullable Integer value) {
            this.maxFragmentLength = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT noMatchSize(@Nullable Integer value) {
            this.noMatchSize = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT numberOfFragments(@Nullable Integer value) {
            this.numberOfFragments = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT options(Map<String, Map<String, JsonData>> map) {
            this.options = AbstractBuilder._mapPutAll(this.options, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT options(String key, Map<String, JsonData> value) {
            this.options = AbstractBuilder._mapPut(this.options, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT order(@Nullable HighlighterOrder value) {
            this.order = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT phraseLimit(@Nullable Integer value) {
            this.phraseLimit = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT postTags(List<String> list) {
            this.postTags = AbstractBuilder._listAddAll(this.postTags, list);
            return this.self();
        }

        @Nonnull
        public final BuilderT postTags(String value, String ... values) {
            this.postTags = AbstractBuilder._listAdd(this.postTags, value, values);
            return this.self();
        }

        @Nonnull
        public final BuilderT preTags(List<String> list) {
            this.preTags = AbstractBuilder._listAddAll(this.preTags, list);
            return this.self();
        }

        @Nonnull
        public final BuilderT preTags(String value, String ... values) {
            this.preTags = AbstractBuilder._listAdd(this.preTags, value, values);
            return this.self();
        }

        @Nonnull
        public final BuilderT requireFieldMatch(@Nullable Boolean value) {
            this.requireFieldMatch = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT tagsSchema(@Nullable HighlighterTagsSchema value) {
            this.tagsSchema = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT type(@Nullable HighlighterType value) {
            this.type = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT type(Function<HighlighterType.Builder, ObjectBuilder<HighlighterType>> fn) {
            return this.type(fn.apply(new HighlighterType.Builder()).build());
        }
    }
}

