/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.SuggestMode;
import org.opensearch.client.opensearch.core.search.FieldSuggester;
import org.opensearch.client.opensearch.core.search.FieldSuggesterVariant;
import org.opensearch.client.opensearch.core.search.StringDistance;
import org.opensearch.client.opensearch.core.search.SuggestSort;
import org.opensearch.client.opensearch.core.search.SuggesterBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TermSuggester
extends SuggesterBase
implements FieldSuggesterVariant,
ToCopyableBuilder<Builder, TermSuggester> {
    @Nullable
    private final Boolean lowercaseTerms;
    @Nullable
    private final Integer maxEdits;
    @Nullable
    private final Integer maxInspections;
    @Nullable
    private final Float maxTermFreq;
    @Nullable
    private final Float minDocFreq;
    @Nullable
    private final Integer minWordLength;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final SuggestSort sort;
    @Nullable
    private final StringDistance stringDistance;
    @Nullable
    private final SuggestMode suggestMode;
    @Nullable
    private final String text;
    public static final JsonpDeserializer<TermSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermSuggester::setupTermSuggesterDeserializer);

    private TermSuggester(Builder builder) {
        super(builder);
        this.lowercaseTerms = builder.lowercaseTerms;
        this.maxEdits = builder.maxEdits;
        this.maxInspections = builder.maxInspections;
        this.maxTermFreq = builder.maxTermFreq;
        this.minDocFreq = builder.minDocFreq;
        this.minWordLength = builder.minWordLength;
        this.prefixLength = builder.prefixLength;
        this.shardSize = builder.shardSize;
        this.sort = builder.sort;
        this.stringDistance = builder.stringDistance;
        this.suggestMode = builder.suggestMode;
        this.text = builder.text;
    }

    public static TermSuggester of(Function<Builder, ObjectBuilder<TermSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FieldSuggester.Kind _fieldSuggesterKind() {
        return FieldSuggester.Kind.Term;
    }

    @Nullable
    public final Boolean lowercaseTerms() {
        return this.lowercaseTerms;
    }

    @Nullable
    public final Integer maxEdits() {
        return this.maxEdits;
    }

    @Nullable
    public final Integer maxInspections() {
        return this.maxInspections;
    }

    @Nullable
    public final Float maxTermFreq() {
        return this.maxTermFreq;
    }

    @Nullable
    public final Float minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public final Integer minWordLength() {
        return this.minWordLength;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final SuggestSort sort() {
        return this.sort;
    }

    @Nullable
    public final StringDistance stringDistance() {
        return this.stringDistance;
    }

    @Nullable
    public final SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lowercaseTerms != null) {
            generator.writeKey("lowercase_terms");
            generator.write(this.lowercaseTerms.booleanValue());
        }
        if (this.maxEdits != null) {
            generator.writeKey("max_edits");
            generator.write(this.maxEdits.intValue());
        }
        if (this.maxInspections != null) {
            generator.writeKey("max_inspections");
            generator.write(this.maxInspections.intValue());
        }
        if (this.maxTermFreq != null) {
            generator.writeKey("max_term_freq");
            generator.write((double)this.maxTermFreq.floatValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write((double)this.minDocFreq.floatValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength.intValue());
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            this.sort.serialize(generator, mapper);
        }
        if (this.stringDistance != null) {
            generator.writeKey("string_distance");
            this.stringDistance.serialize(generator, mapper);
        }
        if (this.suggestMode != null) {
            generator.writeKey("suggest_mode");
            this.suggestMode.serialize(generator, mapper);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTermSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        TermSuggester.setupSuggesterBaseDeserializer(op);
        op.add(Builder::lowercaseTerms, JsonpDeserializer.booleanDeserializer(), "lowercase_terms");
        op.add(Builder::maxEdits, JsonpDeserializer.integerDeserializer(), "max_edits");
        op.add(Builder::maxInspections, JsonpDeserializer.integerDeserializer(), "max_inspections");
        op.add(Builder::maxTermFreq, JsonpDeserializer.floatDeserializer(), "max_term_freq");
        op.add(Builder::minDocFreq, JsonpDeserializer.floatDeserializer(), "min_doc_freq");
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::sort, SuggestSort._DESERIALIZER, "sort");
        op.add(Builder::stringDistance, StringDistance._DESERIALIZER, "string_distance");
        op.add(Builder::suggestMode, SuggestMode._DESERIALIZER, "suggest_mode");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.lowercaseTerms);
        result = 31 * result + Objects.hashCode(this.maxEdits);
        result = 31 * result + Objects.hashCode(this.maxInspections);
        result = 31 * result + Objects.hashCode(this.maxTermFreq);
        result = 31 * result + Objects.hashCode(this.minDocFreq);
        result = 31 * result + Objects.hashCode(this.minWordLength);
        result = 31 * result + Objects.hashCode(this.prefixLength);
        result = 31 * result + Objects.hashCode(this.shardSize);
        result = 31 * result + Objects.hashCode(this.sort);
        result = 31 * result + Objects.hashCode(this.stringDistance);
        result = 31 * result + Objects.hashCode(this.suggestMode);
        result = 31 * result + Objects.hashCode(this.text);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermSuggester other = (TermSuggester)o;
        return Objects.equals(this.lowercaseTerms, other.lowercaseTerms) && Objects.equals(this.maxEdits, other.maxEdits) && Objects.equals(this.maxInspections, other.maxInspections) && Objects.equals(this.maxTermFreq, other.maxTermFreq) && Objects.equals(this.minDocFreq, other.minDocFreq) && Objects.equals(this.minWordLength, other.minWordLength) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.sort, other.sort) && Objects.equals(this.stringDistance, other.stringDistance) && Objects.equals(this.suggestMode, other.suggestMode) && Objects.equals(this.text, other.text);
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TermSuggester> {
        @Nullable
        private Boolean lowercaseTerms;
        @Nullable
        private Integer maxEdits;
        @Nullable
        private Integer maxInspections;
        @Nullable
        private Float maxTermFreq;
        @Nullable
        private Float minDocFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private Integer shardSize;
        @Nullable
        private SuggestSort sort;
        @Nullable
        private StringDistance stringDistance;
        @Nullable
        private SuggestMode suggestMode;
        @Nullable
        private String text;

        public Builder() {
        }

        private Builder(TermSuggester o) {
            super(o);
            this.lowercaseTerms = o.lowercaseTerms;
            this.maxEdits = o.maxEdits;
            this.maxInspections = o.maxInspections;
            this.maxTermFreq = o.maxTermFreq;
            this.minDocFreq = o.minDocFreq;
            this.minWordLength = o.minWordLength;
            this.prefixLength = o.prefixLength;
            this.shardSize = o.shardSize;
            this.sort = o.sort;
            this.stringDistance = o.stringDistance;
            this.suggestMode = o.suggestMode;
            this.text = o.text;
        }

        private Builder(Builder o) {
            super(o);
            this.lowercaseTerms = o.lowercaseTerms;
            this.maxEdits = o.maxEdits;
            this.maxInspections = o.maxInspections;
            this.maxTermFreq = o.maxTermFreq;
            this.minDocFreq = o.minDocFreq;
            this.minWordLength = o.minWordLength;
            this.prefixLength = o.prefixLength;
            this.shardSize = o.shardSize;
            this.sort = o.sort;
            this.stringDistance = o.stringDistance;
            this.suggestMode = o.suggestMode;
            this.text = o.text;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder lowercaseTerms(@Nullable Boolean value) {
            this.lowercaseTerms = value;
            return this;
        }

        @Nonnull
        public final Builder maxEdits(@Nullable Integer value) {
            this.maxEdits = value;
            return this;
        }

        @Nonnull
        public final Builder maxInspections(@Nullable Integer value) {
            this.maxInspections = value;
            return this;
        }

        @Nonnull
        public final Builder maxTermFreq(@Nullable Float value) {
            this.maxTermFreq = value;
            return this;
        }

        @Nonnull
        public final Builder minDocFreq(@Nullable Float value) {
            this.minDocFreq = value;
            return this;
        }

        @Nonnull
        public final Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        @Nonnull
        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        @Nonnull
        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Nonnull
        public final Builder sort(@Nullable SuggestSort value) {
            this.sort = value;
            return this;
        }

        @Nonnull
        public final Builder stringDistance(@Nullable StringDistance value) {
            this.stringDistance = value;
            return this;
        }

        @Nonnull
        public final Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        @Nonnull
        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Override
        @Nonnull
        public TermSuggester build() {
            this._checkSingleUse();
            return new TermSuggester(this);
        }
    }
}

