/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.termvectors;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FieldStatistics
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, FieldStatistics> {
    private final int docCount;
    private final long sumDocFreq;
    private final long sumTtf;
    public static final JsonpDeserializer<FieldStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldStatistics::setupFieldStatisticsDeserializer);

    private FieldStatistics(Builder builder) {
        this.docCount = ApiTypeHelper.requireNonNull(builder.docCount, this, "docCount");
        this.sumDocFreq = ApiTypeHelper.requireNonNull(builder.sumDocFreq, this, "sumDocFreq");
        this.sumTtf = ApiTypeHelper.requireNonNull(builder.sumTtf, this, "sumTtf");
    }

    public static FieldStatistics of(Function<Builder, ObjectBuilder<FieldStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int docCount() {
        return this.docCount;
    }

    public final long sumDocFreq() {
        return this.sumDocFreq;
    }

    public final long sumTtf() {
        return this.sumTtf;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        generator.writeKey("sum_doc_freq");
        generator.write(this.sumDocFreq);
        generator.writeKey("sum_ttf");
        generator.write(this.sumTtf);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFieldStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docCount, JsonpDeserializer.integerDeserializer(), "doc_count");
        op.add(Builder::sumDocFreq, JsonpDeserializer.longDeserializer(), "sum_doc_freq");
        op.add(Builder::sumTtf, JsonpDeserializer.longDeserializer(), "sum_ttf");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.docCount);
        result = 31 * result + Long.hashCode(this.sumDocFreq);
        result = 31 * result + Long.hashCode(this.sumTtf);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldStatistics other = (FieldStatistics)o;
        return this.docCount == other.docCount && this.sumDocFreq == other.sumDocFreq && this.sumTtf == other.sumTtf;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FieldStatistics> {
        private Integer docCount;
        private Long sumDocFreq;
        private Long sumTtf;

        public Builder() {
        }

        private Builder(FieldStatistics o) {
            this.docCount = o.docCount;
            this.sumDocFreq = o.sumDocFreq;
            this.sumTtf = o.sumTtf;
        }

        private Builder(Builder o) {
            this.docCount = o.docCount;
            this.sumDocFreq = o.sumDocFreq;
            this.sumTtf = o.sumTtf;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder docCount(int value) {
            this.docCount = value;
            return this;
        }

        @Nonnull
        public final Builder sumDocFreq(long value) {
            this.sumDocFreq = value;
            return this;
        }

        @Nonnull
        public final Builder sumTtf(long value) {
            this.sumTtf = value;
            return this;
        }

        @Override
        @Nonnull
        public FieldStatistics build() {
            this._checkSingleUse();
            return new FieldStatistics(this);
        }
    }
}

