/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TemplateMapping
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TemplateMapping> {
    @Nonnull
    private final Map<String, Alias> aliases;
    @Nonnull
    private final List<String> indexPatterns;
    @Nonnull
    private final TypeMapping mappings;
    private final int order;
    @Nonnull
    private final Map<String, JsonData> settings;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<TemplateMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TemplateMapping::setupTemplateMappingDeserializer);

    private TemplateMapping(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiableRequired(builder.aliases, (Object)this, "aliases");
        this.indexPatterns = ApiTypeHelper.unmodifiableRequired(builder.indexPatterns, (Object)this, "indexPatterns");
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
        this.order = ApiTypeHelper.requireNonNull(builder.order, this, "order");
        this.settings = ApiTypeHelper.unmodifiableRequired(builder.settings, (Object)this, "settings");
        this.version = builder.version;
    }

    public static TemplateMapping of(Function<Builder, ObjectBuilder<TemplateMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nonnull
    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nonnull
    public final TypeMapping mappings() {
        return this.mappings;
    }

    public final int order() {
        return this.order;
    }

    @Nonnull
    public final Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aliases");
        generator.writeStartObject();
        for (Map.Entry<String, Alias> entry : this.aliases.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("index_patterns");
        generator.writeStartArray();
        for (String string : this.indexPatterns) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        generator.writeKey("order");
        generator.write(this.order);
        generator.writeKey("settings");
        generator.writeStartObject();
        for (Map.Entry entry : this.settings.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTemplateMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::order, JsonpDeserializer.integerDeserializer(), "order");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.indexPatterns.hashCode();
        result = 31 * result + this.mappings.hashCode();
        result = 31 * result + Integer.hashCode(this.order);
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateMapping other = (TemplateMapping)o;
        return this.aliases.equals(other.aliases) && this.indexPatterns.equals(other.indexPatterns) && this.mappings.equals(other.mappings) && this.order == other.order && this.settings.equals(other.settings) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TemplateMapping> {
        private Map<String, Alias> aliases;
        private List<String> indexPatterns;
        private TypeMapping mappings;
        private Integer order;
        private Map<String, JsonData> settings;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(TemplateMapping o) {
            this.aliases = Builder._mapCopy(o.aliases);
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.mappings = o.mappings;
            this.order = o.order;
            this.settings = Builder._mapCopy(o.settings);
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.aliases = Builder._mapCopy(o.aliases);
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.mappings = o.mappings;
            this.order = o.order;
            this.settings = Builder._mapCopy(o.settings);
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aliases(Map<String, Alias> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        @Nonnull
        public final Builder aliases(String key, Alias value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        @Nonnull
        public final Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(key, fn.apply(new Alias.Builder()).build());
        }

        @Nonnull
        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        @Nonnull
        public final Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        @Nonnull
        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Nonnull
        public final Builder order(int value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public final Builder settings(Map<String, JsonData> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        @Nonnull
        public final Builder settings(String key, JsonData value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public TemplateMapping build() {
            this._checkSingleUse();
            return new TemplateMapping(this);
        }
    }
}

