/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DateIndexNameProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, DateIndexNameProcessor> {
    @Nonnull
    private final List<String> dateFormats;
    @Nonnull
    private final String dateRounding;
    @Nonnull
    private final String field;
    @Nullable
    private final String indexNameFormat;
    @Nullable
    private final String indexNamePrefix;
    @Nullable
    private final String locale;
    @Nullable
    private final String timezone;
    public static final JsonpDeserializer<DateIndexNameProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateIndexNameProcessor::setupDateIndexNameProcessorDeserializer);

    private DateIndexNameProcessor(Builder builder) {
        super(builder);
        this.dateFormats = ApiTypeHelper.unmodifiableRequired(builder.dateFormats, (Object)this, "dateFormats");
        this.dateRounding = ApiTypeHelper.requireNonNull(builder.dateRounding, this, "dateRounding");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.indexNameFormat = builder.indexNameFormat;
        this.indexNamePrefix = builder.indexNamePrefix;
        this.locale = builder.locale;
        this.timezone = builder.timezone;
    }

    public static DateIndexNameProcessor of(Function<Builder, ObjectBuilder<DateIndexNameProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.DateIndexName;
    }

    @Nonnull
    public final List<String> dateFormats() {
        return this.dateFormats;
    }

    @Nonnull
    public final String dateRounding() {
        return this.dateRounding;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String indexNameFormat() {
        return this.indexNameFormat;
    }

    @Nullable
    public final String indexNamePrefix() {
        return this.indexNamePrefix;
    }

    @Nullable
    public final String locale() {
        return this.locale;
    }

    @Nullable
    public final String timezone() {
        return this.timezone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("date_formats");
        generator.writeStartArray();
        for (String item0 : this.dateFormats) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("date_rounding");
        generator.write(this.dateRounding);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.indexNameFormat != null) {
            generator.writeKey("index_name_format");
            generator.write(this.indexNameFormat);
        }
        if (this.indexNamePrefix != null) {
            generator.writeKey("index_name_prefix");
            generator.write(this.indexNamePrefix);
        }
        if (this.locale != null) {
            generator.writeKey("locale");
            generator.write(this.locale);
        }
        if (this.timezone != null) {
            generator.writeKey("timezone");
            generator.write(this.timezone);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDateIndexNameProcessorDeserializer(ObjectDeserializer<Builder> op) {
        DateIndexNameProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::dateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "date_formats");
        op.add(Builder::dateRounding, JsonpDeserializer.stringDeserializer(), "date_rounding");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::indexNameFormat, JsonpDeserializer.stringDeserializer(), "index_name_format");
        op.add(Builder::indexNamePrefix, JsonpDeserializer.stringDeserializer(), "index_name_prefix");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::timezone, JsonpDeserializer.stringDeserializer(), "timezone");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.dateFormats.hashCode();
        result = 31 * result + this.dateRounding.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.indexNameFormat);
        result = 31 * result + Objects.hashCode(this.indexNamePrefix);
        result = 31 * result + Objects.hashCode(this.locale);
        result = 31 * result + Objects.hashCode(this.timezone);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateIndexNameProcessor other = (DateIndexNameProcessor)o;
        return this.dateFormats.equals(other.dateFormats) && this.dateRounding.equals(other.dateRounding) && this.field.equals(other.field) && Objects.equals(this.indexNameFormat, other.indexNameFormat) && Objects.equals(this.indexNamePrefix, other.indexNamePrefix) && Objects.equals(this.locale, other.locale) && Objects.equals(this.timezone, other.timezone);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DateIndexNameProcessor> {
        private List<String> dateFormats;
        private String dateRounding;
        private String field;
        @Nullable
        private String indexNameFormat;
        @Nullable
        private String indexNamePrefix;
        @Nullable
        private String locale;
        @Nullable
        private String timezone;

        public Builder() {
        }

        private Builder(DateIndexNameProcessor o) {
            super(o);
            this.dateFormats = Builder._listCopy(o.dateFormats);
            this.dateRounding = o.dateRounding;
            this.field = o.field;
            this.indexNameFormat = o.indexNameFormat;
            this.indexNamePrefix = o.indexNamePrefix;
            this.locale = o.locale;
            this.timezone = o.timezone;
        }

        private Builder(Builder o) {
            super(o);
            this.dateFormats = Builder._listCopy(o.dateFormats);
            this.dateRounding = o.dateRounding;
            this.field = o.field;
            this.indexNameFormat = o.indexNameFormat;
            this.indexNamePrefix = o.indexNamePrefix;
            this.locale = o.locale;
            this.timezone = o.timezone;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder dateFormats(List<String> list) {
            this.dateFormats = Builder._listAddAll(this.dateFormats, list);
            return this;
        }

        @Nonnull
        public final Builder dateFormats(String value, String ... values) {
            this.dateFormats = Builder._listAdd(this.dateFormats, value, values);
            return this;
        }

        @Nonnull
        public final Builder dateRounding(String value) {
            this.dateRounding = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder indexNameFormat(@Nullable String value) {
            this.indexNameFormat = value;
            return this;
        }

        @Nonnull
        public final Builder indexNamePrefix(@Nullable String value) {
            this.indexNamePrefix = value;
            return this;
        }

        @Nonnull
        public final Builder locale(@Nullable String value) {
            this.locale = value;
            return this;
        }

        @Nonnull
        public final Builder timezone(@Nullable String value) {
            this.timezone = value;
            return this;
        }

        @Override
        @Nonnull
        public DateIndexNameProcessor build() {
            this._checkSingleUse();
            return new DateIndexNameProcessor(this);
        }
    }
}

