/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PipelineProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, PipelineProcessor> {
    @Nullable
    private final Boolean ignoreMissingPipeline;
    @Nonnull
    private final String name;
    public static final JsonpDeserializer<PipelineProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineProcessor::setupPipelineProcessorDeserializer);

    private PipelineProcessor(Builder builder) {
        super(builder);
        this.ignoreMissingPipeline = builder.ignoreMissingPipeline;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static PipelineProcessor of(Function<Builder, ObjectBuilder<PipelineProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Pipeline;
    }

    @Nullable
    public final Boolean ignoreMissingPipeline() {
        return this.ignoreMissingPipeline;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreMissingPipeline != null) {
            generator.writeKey("ignore_missing_pipeline");
            generator.write(this.ignoreMissingPipeline.booleanValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPipelineProcessorDeserializer(ObjectDeserializer<Builder> op) {
        PipelineProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::ignoreMissingPipeline, JsonpDeserializer.booleanDeserializer(), "ignore_missing_pipeline");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissingPipeline);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineProcessor other = (PipelineProcessor)o;
        return Objects.equals(this.ignoreMissingPipeline, other.ignoreMissingPipeline) && this.name.equals(other.name);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PipelineProcessor> {
        @Nullable
        private Boolean ignoreMissingPipeline;
        private String name;

        public Builder() {
        }

        private Builder(PipelineProcessor o) {
            super(o);
            this.ignoreMissingPipeline = o.ignoreMissingPipeline;
            this.name = o.name;
        }

        private Builder(Builder o) {
            super(o);
            this.ignoreMissingPipeline = o.ignoreMissingPipeline;
            this.name = o.name;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ignoreMissingPipeline(@Nullable Boolean value) {
            this.ignoreMissingPipeline = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        @Nonnull
        public PipelineProcessor build() {
            this._checkSingleUse();
            return new PipelineProcessor(this);
        }
    }
}

