/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.UndeployModelResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UndeployModelRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UndeployModelRequest> {
    @Nullable
    private final String modelId;
    @Nonnull
    private final List<String> modelIds;
    @Nonnull
    private final List<String> nodeIds;
    public static final JsonpDeserializer<UndeployModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UndeployModelRequest::setupUndeployModelRequestDeserializer);
    public static final Endpoint<UndeployModelRequest, UndeployModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UndeployModelRequest, UndeployModelResponse>(request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_ml/models/_undeploy";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_ml/models/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/_undeploy");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UndeployModelResponse._DESERIALIZER);

    private UndeployModelRequest(Builder builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelIds = ApiTypeHelper.unmodifiable(builder.modelIds);
        this.nodeIds = ApiTypeHelper.unmodifiable(builder.nodeIds);
    }

    public static UndeployModelRequest of(Function<Builder, ObjectBuilder<UndeployModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nonnull
    public final List<String> modelIds() {
        return this.modelIds;
    }

    @Nonnull
    public final List<String> nodeIds() {
        return this.nodeIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.modelIds)) {
            generator.writeKey("model_ids");
            generator.writeStartArray();
            for (String item0 : this.modelIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodeIds)) {
            generator.writeKey("node_ids");
            generator.writeStartArray();
            for (String item0 : this.nodeIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUndeployModelRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "model_ids");
        op.add(Builder::nodeIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "node_ids");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.modelId);
        result = 31 * result + Objects.hashCode(this.modelIds);
        result = 31 * result + Objects.hashCode(this.nodeIds);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UndeployModelRequest other = (UndeployModelRequest)o;
        return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.modelIds, other.modelIds) && Objects.equals(this.nodeIds, other.nodeIds);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UndeployModelRequest> {
        @Nullable
        private String modelId;
        @Nullable
        private List<String> modelIds;
        @Nullable
        private List<String> nodeIds;

        public Builder() {
        }

        private Builder(UndeployModelRequest o) {
            super(o);
            this.modelId = o.modelId;
            this.modelIds = Builder._listCopy(o.modelIds);
            this.nodeIds = Builder._listCopy(o.nodeIds);
        }

        private Builder(Builder o) {
            super(o);
            this.modelId = o.modelId;
            this.modelIds = Builder._listCopy(o.modelIds);
            this.nodeIds = Builder._listCopy(o.nodeIds);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder modelIds(List<String> list) {
            this.modelIds = Builder._listAddAll(this.modelIds, list);
            return this;
        }

        @Nonnull
        public final Builder modelIds(String value, String ... values) {
            this.modelIds = Builder._listAdd(this.modelIds, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeIds(List<String> list) {
            this.nodeIds = Builder._listAddAll(this.nodeIds, list);
            return this;
        }

        @Nonnull
        public final Builder nodeIds(String value, String ... values) {
            this.nodeIds = Builder._listAdd(this.nodeIds, value, values);
            return this;
        }

        @Override
        @Nonnull
        public UndeployModelRequest build() {
            this._checkSingleUse();
            return new UndeployModelRequest(this);
        }
    }
}

