/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeInfoOSCPU
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeInfoOSCPU> {
    @Nonnull
    private final String cacheSize;
    private final long cacheSizeInBytes;
    private final int coresPerSocket;
    private final int mhz;
    @Nonnull
    private final String model;
    private final int totalCores;
    private final int totalSockets;
    @Nonnull
    private final String vendor;
    public static final JsonpDeserializer<NodeInfoOSCPU> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoOSCPU::setupNodeInfoOSCPUDeserializer);

    private NodeInfoOSCPU(Builder builder) {
        this.cacheSize = ApiTypeHelper.requireNonNull(builder.cacheSize, this, "cacheSize");
        this.cacheSizeInBytes = ApiTypeHelper.requireNonNull(builder.cacheSizeInBytes, this, "cacheSizeInBytes");
        this.coresPerSocket = ApiTypeHelper.requireNonNull(builder.coresPerSocket, this, "coresPerSocket");
        this.mhz = ApiTypeHelper.requireNonNull(builder.mhz, this, "mhz");
        this.model = ApiTypeHelper.requireNonNull(builder.model, this, "model");
        this.totalCores = ApiTypeHelper.requireNonNull(builder.totalCores, this, "totalCores");
        this.totalSockets = ApiTypeHelper.requireNonNull(builder.totalSockets, this, "totalSockets");
        this.vendor = ApiTypeHelper.requireNonNull(builder.vendor, this, "vendor");
    }

    public static NodeInfoOSCPU of(Function<Builder, ObjectBuilder<NodeInfoOSCPU>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String cacheSize() {
        return this.cacheSize;
    }

    public final long cacheSizeInBytes() {
        return this.cacheSizeInBytes;
    }

    public final int coresPerSocket() {
        return this.coresPerSocket;
    }

    public final int mhz() {
        return this.mhz;
    }

    @Nonnull
    public final String model() {
        return this.model;
    }

    public final int totalCores() {
        return this.totalCores;
    }

    public final int totalSockets() {
        return this.totalSockets;
    }

    @Nonnull
    public final String vendor() {
        return this.vendor;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("cache_size_in_bytes");
        generator.write(this.cacheSizeInBytes);
        generator.writeKey("cores_per_socket");
        generator.write(this.coresPerSocket);
        generator.writeKey("mhz");
        generator.write(this.mhz);
        generator.writeKey("model");
        generator.write(this.model);
        generator.writeKey("total_cores");
        generator.write(this.totalCores);
        generator.writeKey("total_sockets");
        generator.write(this.totalSockets);
        generator.writeKey("vendor");
        generator.write(this.vendor);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeInfoOSCPUDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheSize, JsonpDeserializer.stringDeserializer(), "cache_size");
        op.add(Builder::cacheSizeInBytes, JsonpDeserializer.longDeserializer(), "cache_size_in_bytes");
        op.add(Builder::coresPerSocket, JsonpDeserializer.integerDeserializer(), "cores_per_socket");
        op.add(Builder::mhz, JsonpDeserializer.integerDeserializer(), "mhz");
        op.add(Builder::model, JsonpDeserializer.stringDeserializer(), "model");
        op.add(Builder::totalCores, JsonpDeserializer.integerDeserializer(), "total_cores");
        op.add(Builder::totalSockets, JsonpDeserializer.integerDeserializer(), "total_sockets");
        op.add(Builder::vendor, JsonpDeserializer.stringDeserializer(), "vendor");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.cacheSize.hashCode();
        result = 31 * result + Long.hashCode(this.cacheSizeInBytes);
        result = 31 * result + Integer.hashCode(this.coresPerSocket);
        result = 31 * result + Integer.hashCode(this.mhz);
        result = 31 * result + this.model.hashCode();
        result = 31 * result + Integer.hashCode(this.totalCores);
        result = 31 * result + Integer.hashCode(this.totalSockets);
        result = 31 * result + this.vendor.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoOSCPU other = (NodeInfoOSCPU)o;
        return this.cacheSize.equals(other.cacheSize) && this.cacheSizeInBytes == other.cacheSizeInBytes && this.coresPerSocket == other.coresPerSocket && this.mhz == other.mhz && this.model.equals(other.model) && this.totalCores == other.totalCores && this.totalSockets == other.totalSockets && this.vendor.equals(other.vendor);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeInfoOSCPU> {
        private String cacheSize;
        private Long cacheSizeInBytes;
        private Integer coresPerSocket;
        private Integer mhz;
        private String model;
        private Integer totalCores;
        private Integer totalSockets;
        private String vendor;

        public Builder() {
        }

        private Builder(NodeInfoOSCPU o) {
            this.cacheSize = o.cacheSize;
            this.cacheSizeInBytes = o.cacheSizeInBytes;
            this.coresPerSocket = o.coresPerSocket;
            this.mhz = o.mhz;
            this.model = o.model;
            this.totalCores = o.totalCores;
            this.totalSockets = o.totalSockets;
            this.vendor = o.vendor;
        }

        private Builder(Builder o) {
            this.cacheSize = o.cacheSize;
            this.cacheSizeInBytes = o.cacheSizeInBytes;
            this.coresPerSocket = o.coresPerSocket;
            this.mhz = o.mhz;
            this.model = o.model;
            this.totalCores = o.totalCores;
            this.totalSockets = o.totalSockets;
            this.vendor = o.vendor;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cacheSize(String value) {
            this.cacheSize = value;
            return this;
        }

        @Nonnull
        public final Builder cacheSizeInBytes(long value) {
            this.cacheSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder coresPerSocket(int value) {
            this.coresPerSocket = value;
            return this;
        }

        @Nonnull
        public final Builder mhz(int value) {
            this.mhz = value;
            return this;
        }

        @Nonnull
        public final Builder model(String value) {
            this.model = value;
            return this;
        }

        @Nonnull
        public final Builder totalCores(int value) {
            this.totalCores = value;
            return this;
        }

        @Nonnull
        public final Builder totalSockets(int value) {
            this.totalSockets = value;
            return this;
        }

        @Nonnull
        public final Builder vendor(String value) {
            this.vendor = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeInfoOSCPU build() {
            this._checkSingleUse();
            return new NodeInfoOSCPU(this);
        }
    }
}

