/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.MLOpenSearchReranker;
import org.opensearch.client.opensearch.search_pipeline.RerankContext;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessor;
import org.opensearch.client.opensearch.search_pipeline.ResponseProcessorVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RerankResponseProcessor
implements ResponseProcessorVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, RerankResponseProcessor> {
    @Nullable
    private final RerankContext context;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean ignoreFailure;
    @Nullable
    private final MLOpenSearchReranker mlOpensearch;
    @Nullable
    private final String tag;
    public static final JsonpDeserializer<RerankResponseProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerankResponseProcessor::setupRerankResponseProcessorDeserializer);

    private RerankResponseProcessor(Builder builder) {
        this.context = builder.context;
        this.description = builder.description;
        this.ignoreFailure = builder.ignoreFailure;
        this.mlOpensearch = builder.mlOpensearch;
        this.tag = builder.tag;
    }

    public static RerankResponseProcessor of(Function<Builder, ObjectBuilder<RerankResponseProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ResponseProcessor.Kind _responseProcessorKind() {
        return ResponseProcessor.Kind.Rerank;
    }

    @Nullable
    public final RerankContext context() {
        return this.context;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nullable
    public final MLOpenSearchReranker mlOpensearch() {
        return this.mlOpensearch;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.context != null) {
            generator.writeKey("context");
            this.context.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (this.mlOpensearch != null) {
            generator.writeKey("ml_opensearch");
            this.mlOpensearch.serialize(generator, mapper);
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRerankResponseProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::context, RerankContext._DESERIALIZER, "context");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(Builder::mlOpensearch, MLOpenSearchReranker._DESERIALIZER, "ml_opensearch");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.context);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + Objects.hashCode(this.mlOpensearch);
        result = 31 * result + Objects.hashCode(this.tag);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerankResponseProcessor other = (RerankResponseProcessor)o;
        return Objects.equals(this.context, other.context) && Objects.equals(this.description, other.description) && Objects.equals(this.ignoreFailure, other.ignoreFailure) && Objects.equals(this.mlOpensearch, other.mlOpensearch) && Objects.equals(this.tag, other.tag);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RerankResponseProcessor> {
        @Nullable
        private RerankContext context;
        @Nullable
        private String description;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private MLOpenSearchReranker mlOpensearch;
        @Nullable
        private String tag;

        public Builder() {
        }

        private Builder(RerankResponseProcessor o) {
            this.context = o.context;
            this.description = o.description;
            this.ignoreFailure = o.ignoreFailure;
            this.mlOpensearch = o.mlOpensearch;
            this.tag = o.tag;
        }

        private Builder(Builder o) {
            this.context = o.context;
            this.description = o.description;
            this.ignoreFailure = o.ignoreFailure;
            this.mlOpensearch = o.mlOpensearch;
            this.tag = o.tag;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder context(@Nullable RerankContext value) {
            this.context = value;
            return this;
        }

        @Nonnull
        public final Builder context(Function<RerankContext.Builder, ObjectBuilder<RerankContext>> fn) {
            return this.context(fn.apply(new RerankContext.Builder()).build());
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Nonnull
        public final Builder mlOpensearch(@Nullable MLOpenSearchReranker value) {
            this.mlOpensearch = value;
            return this;
        }

        @Nonnull
        public final Builder mlOpensearch(Function<MLOpenSearchReranker.Builder, ObjectBuilder<MLOpenSearchReranker>> fn) {
            return this.mlOpensearch(fn.apply(new MLOpenSearchReranker.Builder()).build());
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Override
        @Nonnull
        public RerankResponseProcessor build() {
            this._checkSingleUse();
            return new RerankResponseProcessor(this);
        }
    }
}

