/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.tasks;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch._types.TaskFailure;
import org.opensearch.client.opensearch.tasks.TaskExecutingNode;
import org.opensearch.client.opensearch.tasks.TaskInfos;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class TaskListResponseBase
implements PlainJsonSerializable {
    @Nonnull
    private final List<ErrorCause> nodeFailures;
    @Nonnull
    private final Map<String, TaskExecutingNode> nodes;
    @Nonnull
    private final List<TaskFailure> taskFailures;
    @Nullable
    private final TaskInfos tasks;

    protected TaskListResponseBase(AbstractBuilder<?> builder) {
        this.nodeFailures = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).nodeFailures);
        this.nodes = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).nodes);
        this.taskFailures = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).taskFailures);
        this.tasks = ((AbstractBuilder)builder).tasks;
    }

    @Nonnull
    public final List<ErrorCause> nodeFailures() {
        return this.nodeFailures;
    }

    @Nonnull
    public final Map<String, TaskExecutingNode> nodes() {
        return this.nodes;
    }

    @Nonnull
    public final List<TaskFailure> taskFailures() {
        return this.taskFailures;
    }

    @Nullable
    public final TaskInfos tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodeFailures)) {
            generator.writeKey("node_failures");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.nodeFailures) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry entry : this.nodes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((TaskExecutingNode)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.taskFailures)) {
            generator.writeKey("task_failures");
            generator.writeStartArray();
            for (TaskFailure taskFailure : this.taskFailures) {
                taskFailure.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tasks != null) {
            generator.writeKey("tasks");
            this.tasks.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTaskListResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::nodeFailures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "node_failures");
        op.add(AbstractBuilder::nodes, JsonpDeserializer.stringMapDeserializer(TaskExecutingNode._DESERIALIZER), "nodes");
        op.add(AbstractBuilder::taskFailures, JsonpDeserializer.arrayDeserializer(TaskFailure._DESERIALIZER), "task_failures");
        op.add(AbstractBuilder::tasks, TaskInfos._DESERIALIZER, "tasks");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.nodeFailures);
        result = 31 * result + Objects.hashCode(this.nodes);
        result = 31 * result + Objects.hashCode(this.taskFailures);
        result = 31 * result + Objects.hashCode(this.tasks);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskListResponseBase other = (TaskListResponseBase)o;
        return Objects.equals(this.nodeFailures, other.nodeFailures) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.taskFailures, other.taskFailures) && Objects.equals(this.tasks, other.tasks);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private List<ErrorCause> nodeFailures;
        @Nullable
        private Map<String, TaskExecutingNode> nodes;
        @Nullable
        private List<TaskFailure> taskFailures;
        @Nullable
        private TaskInfos tasks;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(TaskListResponseBase o) {
            this.nodeFailures = AbstractBuilder._listCopy(o.nodeFailures);
            this.nodes = AbstractBuilder._mapCopy(o.nodes);
            this.taskFailures = AbstractBuilder._listCopy(o.taskFailures);
            this.tasks = o.tasks;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.nodeFailures = AbstractBuilder._listCopy(o.nodeFailures);
            this.nodes = AbstractBuilder._mapCopy(o.nodes);
            this.taskFailures = AbstractBuilder._listCopy(o.taskFailures);
            this.tasks = o.tasks;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT nodeFailures(List<ErrorCause> list) {
            this.nodeFailures = AbstractBuilder._listAddAll(this.nodeFailures, list);
            return this.self();
        }

        @Nonnull
        public final BuilderT nodeFailures(ErrorCause value, ErrorCause ... values) {
            this.nodeFailures = AbstractBuilder._listAdd(this.nodeFailures, value, values);
            return this.self();
        }

        @Nonnull
        public final BuilderT nodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.nodeFailures(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        @Nonnull
        public final BuilderT nodes(Map<String, TaskExecutingNode> map) {
            this.nodes = AbstractBuilder._mapPutAll(this.nodes, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT nodes(String key, TaskExecutingNode value) {
            this.nodes = AbstractBuilder._mapPut(this.nodes, key, value);
            return this.self();
        }

        @Nonnull
        public final BuilderT nodes(String key, Function<TaskExecutingNode.Builder, ObjectBuilder<TaskExecutingNode>> fn) {
            return this.nodes(key, fn.apply(new TaskExecutingNode.Builder()).build());
        }

        @Nonnull
        public final BuilderT taskFailures(List<TaskFailure> list) {
            this.taskFailures = AbstractBuilder._listAddAll(this.taskFailures, list);
            return this.self();
        }

        @Nonnull
        public final BuilderT taskFailures(TaskFailure value, TaskFailure ... values) {
            this.taskFailures = AbstractBuilder._listAdd(this.taskFailures, value, values);
            return this.self();
        }

        @Nonnull
        public final BuilderT taskFailures(Function<TaskFailure.Builder, ObjectBuilder<TaskFailure>> fn) {
            return this.taskFailures(fn.apply(new TaskFailure.Builder()).build(), new TaskFailure[0]);
        }

        @Nonnull
        public final BuilderT tasks(@Nullable TaskInfos value) {
            this.tasks = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT tasks(Function<TaskInfos.Builder, ObjectBuilder<TaskInfos>> fn) {
            return this.tasks(fn.apply(new TaskInfos.Builder()).build());
        }
    }
}

