/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.async;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.async.InputStreamSubscriber;

@SdkProtectedApi
public final class AbortableInputStreamSubscriber
extends InputStream
implements Subscriber<ByteBuffer>,
Abortable {
    private final InputStreamSubscriber delegate;
    private final Runnable doAfterClose;

    private AbortableInputStreamSubscriber(Builder builder) {
        this(builder, new InputStreamSubscriber());
    }

    @SdkTestInternalApi
    AbortableInputStreamSubscriber(Builder builder, InputStreamSubscriber delegate) {
        this.delegate = delegate;
        this.doAfterClose = builder.doAfterClose == null ? FunctionalUtils.noOpRunnable() : builder.doAfterClose;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void abort() {
        this.close();
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    public void onSubscribe(Subscription s) {
        this.delegate.onSubscribe(s);
    }

    public void onNext(ByteBuffer byteBuffer) {
        this.delegate.onNext(byteBuffer);
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }

    @Override
    public void close() {
        this.delegate.close();
        FunctionalUtils.invokeSafely(() -> this.doAfterClose.run());
    }

    public static final class Builder {
        private Runnable doAfterClose;

        public Builder doAfterClose(Runnable doAfterClose) {
            this.doAfterClose = doAfterClose;
            return this;
        }

        public AbortableInputStreamSubscriber build() {
            return new AbortableInputStreamSubscriber(this);
        }
    }
}

